/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.utils.DomainNotAudited;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.enums.ParametroGrupoEnum;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import lombok.Generated;

@Entity
@Table(name="parametrosgrupo")
@DomainNotAudited
public class ParametroGrupo
implements EloEntity<Long> {
    @Id
    private Long id;
    @NotBlank
    @Size(max=400)
    private @NotBlank @Size(max=400) String descricao;
    @MetaModelIgnore
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="grupoPai")
    private ParametroGrupo grupoPai;

    public ParametroGrupo() {
    }

    public ParametroGrupo(Long id) {
        this();
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public static ParametroGrupo of(ParametroGrupoEnum grupoEnum) {
        ParametroGrupo parametroGrupo = new ParametroGrupo(grupoEnum.getCodigo());
        parametroGrupo.setDescricao(grupoEnum.getDescricao());
        if (Objects.nonNull(grupoEnum.getCodigoPai())) {
            ParametroGrupoEnum parametroGrupoEnumPai = ParametroGrupoEnum.fromCodigo((Long)grupoEnum.getCodigoPai());
            if (Objects.isNull(parametroGrupoEnumPai)) {
                throw new EloValidationException("C\u00f3digo do grupo pai n\u00e3o existe no enum de grupos.");
            }
            ParametroGrupo parametroGrupoPai = new ParametroGrupo(parametroGrupoEnumPai.getCodigo());
            parametroGrupoPai.setDescricao(parametroGrupoEnumPai.getDescricao());
            parametroGrupo.setGrupoPai(parametroGrupoPai);
        }
        return parametroGrupo;
    }

    @Generated
    public String toString() {
        return "ParametroGrupo(id=" + this.getId() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParametroGrupo)) {
            return false;
        }
        ParametroGrupo other = (ParametroGrupo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParametroGrupo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public ParametroGrupo getGrupoPai() {
        return this.grupoPai;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setGrupoPai(ParametroGrupo grupoPai) {
        this.grupoPai = grupoPai;
    }
}

