/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.enums.ParametroTipoEnum;
import br.com.elotech.adm.parametro.BaseParametroEntity;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Modulo;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ParametroGrupo;
import br.com.elotech.protocolo.domain.ParametroPK;
import br.com.elotech.protocolo.enums.ParametroGrupoEnum;
import br.com.elotech.protocolo.enums.ParametroSistemaEnum;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="parametros")
@Audited
public class Parametro
implements EloEntity<ParametroPK>,
BaseParametroEntity<ParametroPK> {
    @EmbeddedId
    private ParametroPK id;
    @NotBlank
    @Length(max=200)
    private @NotBlank @Length(max=200) String descricao;
    @Length(max=50)
    private @Length(max=50) String tipo;
    @Length(max=200)
    private @Length(max=200) String observacao;
    @Length(max=2000)
    private @Length(max=2000) String valor;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="grupo")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private ParametroGrupo grupo;
    @Enumerated(value=EnumType.STRING)
    private ParametroSistemaEnum sistema;

    public Parametro() {
    }

    public Parametro(ParametroPK id) {
        this.id = id;
    }

    public void setExercicio(Long exercicio) {
        if (Objects.isNull(this.id)) {
            this.id = new ParametroPK();
        }
        this.getId().setExercicio(exercicio);
    }

    public Long getExercicio() {
        return Optional.ofNullable(this.getId()).map(ParametroPK::getExercicio).orElse(null);
    }

    public Long getEntidade() {
        return Optional.ofNullable(this.getId()).map(ParametroPK::getEntidade).map(Entidade::getId).orElse(null);
    }

    public Boolean getBooleanValue() {
        return Objects.equals(this.getTipo(), ParametroTipoEnum.CHECKBOX.getValor()) && SimNao.toBoolean((String)this.valor, (Boolean)false) != false;
    }

    public Long getCodigo() {
        return Optional.ofNullable(this.getId()).map(ParametroPK::getId).orElse(null);
    }

    public Boolean isValorNullOrEmpty() {
        return Strings.isNullOrEmpty((String)this.valor);
    }

    public static Parametro of(ParametroEnum parametroEnum, Long entidade, Long exercicio, String modulo) {
        Parametro parametro = new Parametro(ParametroPK.of((Entidade)Entidade.of((Long)entidade), (Modulo)Modulo.of((String)modulo), (Long)exercicio, (Long)parametroEnum.getCodigo()));
        parametro.setTipo(parametroEnum.getTipo().getValor());
        parametro.setDescricao(parametroEnum.getDescricao());
        parametro.setSistema(ParametroSistemaEnum.OXY);
        parametro.setValor(parametroEnum.getValorDefault());
        if (Objects.nonNull(parametroEnum.getGrupo())) {
            parametro.setGrupo(ParametroGrupo.of((ParametroGrupoEnum)parametroEnum.getGrupo()));
        }
        return parametro;
    }

    @Generated
    public ParametroPK getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getValor() {
        return this.valor;
    }

    @Generated
    public ParametroGrupo getGrupo() {
        return this.grupo;
    }

    @Generated
    public ParametroSistemaEnum getSistema() {
        return this.sistema;
    }

    @Generated
    public void setId(ParametroPK id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setValor(String valor) {
        this.valor = valor;
    }

    @Generated
    public void setGrupo(ParametroGrupo grupo) {
        this.grupo = grupo;
    }

    @Generated
    public void setSistema(ParametroSistemaEnum sistema) {
        this.sistema = sistema;
    }
}

