/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.adm.modelodados.enums.TipoModeloEnum;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.protocolo.domain.ModeloAssunto;
import br.com.elotech.protocolo.domain.VariavelSqlModelo;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="modelodados")
public class ModeloDados
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true)
    private Long id;
    @NotNull
    @Length(max=200)
    @Caption(value="Nome")
    private @NotNull @Length(max=200) String nome;
    private Long entidade;
    private Long exercicio;
    private Long codigo;
    private Boolean ativo;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean email;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TipoModeloEnum tipo = TipoModeloEnum.EDITOR;
    @OneToMany(mappedBy="modelo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<VariavelSqlModelo> sqls = new ArrayList();
    @OneToMany(mappedBy="modelo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ModeloAssunto> assuntos = new ArrayList();
    @Transient
    private String templateHtml = "";
    @Transient
    private String arquivoNome;
    @Transient
    private String arquivoFullPath;
    @Transient
    private String arquivoIdentificador;

    @Generated
    public ModeloDados() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public Boolean getEmail() {
        return this.email;
    }

    @Generated
    public TipoModeloEnum getTipo() {
        return this.tipo;
    }

    @Generated
    public List<VariavelSqlModelo> getSqls() {
        return this.sqls;
    }

    @Generated
    public List<ModeloAssunto> getAssuntos() {
        return this.assuntos;
    }

    @Generated
    public String getTemplateHtml() {
        return this.templateHtml;
    }

    @Generated
    public String getArquivoNome() {
        return this.arquivoNome;
    }

    @Generated
    public String getArquivoFullPath() {
        return this.arquivoFullPath;
    }

    @Generated
    public String getArquivoIdentificador() {
        return this.arquivoIdentificador;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setEmail(Boolean email) {
        this.email = email;
    }

    @Generated
    public void setTipo(TipoModeloEnum tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSqls(List<VariavelSqlModelo> sqls) {
        this.sqls = sqls;
    }

    @Generated
    public void setAssuntos(List<ModeloAssunto> assuntos) {
        this.assuntos = assuntos;
    }

    @Generated
    public void setTemplateHtml(String templateHtml) {
        this.templateHtml = templateHtml;
    }

    @Generated
    public void setArquivoNome(String arquivoNome) {
        this.arquivoNome = arquivoNome;
    }

    @Generated
    public void setArquivoFullPath(String arquivoFullPath) {
        this.arquivoFullPath = arquivoFullPath;
    }

    @Generated
    public void setArquivoIdentificador(String arquivoIdentificador) {
        this.arquivoIdentificador = arquivoIdentificador;
    }

    @Generated
    public String toString() {
        return "ModeloDados(id=" + this.getId() + ", nome=" + this.getNome() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", codigo=" + this.getCodigo() + ", ativo=" + this.getAtivo() + ", email=" + this.getEmail() + ", tipo=" + String.valueOf(this.getTipo()) + ", sqls=" + String.valueOf(this.getSqls()) + ", assuntos=" + String.valueOf(this.getAssuntos()) + ", templateHtml=" + this.getTemplateHtml() + ", arquivoNome=" + this.getArquivoNome() + ", arquivoFullPath=" + this.getArquivoFullPath() + ", arquivoIdentificador=" + this.getArquivoIdentificador() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeloDados)) {
            return false;
        }
        ModeloDados other = (ModeloDados)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeloDados;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

