/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.ToModel;
import br.com.elotech.protocolo.domain.Coordenadoria;
import br.com.elotech.protocolo.domain.Diretoria;
import br.com.elotech.protocolo.domain.Gerencia;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.UnidadeOrcamentaria;
import br.com.elotech.protocolo.domain.UsuarioResponsavel;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Audited
@Table(name="locais")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@FilterDef(name="byEntidade", defaultCondition="entidade = :idEntidade", parameters={@ParamDef(name="idEntidade", type="integer")})
@Filter(name="byEntidade")
public class Local
implements EloEntity<LocalPK> {
    @EmbeddedId
    private LocalPK id = new LocalPK();
    @NotBlank
    @Length(max=100)
    private @NotBlank @Length(max=100) String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    @Column(name="ativo")
    private Boolean ativo = Boolean.TRUE;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="diretoria", referencedColumnName="diretoria"))})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Diretoria diretoria;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="gerencia", referencedColumnName="gerencia"))})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Gerencia gerencia;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="coordenadoria", referencedColumnName="coordenadoria"))})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Coordenadoria coordenadoria;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="unidade", referencedColumnName="unidade")), @JoinColumnOrFormula(column=@JoinColumn(name="orgao", referencedColumnName="orgao"))})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private UnidadeOrcamentaria unidadeOrcamentaria;
    @ManyToOne
    @JoinColumn(name="responsavel")
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private UsuarioResponsavel responsavel;
    @Length(max=10)
    @Caption(value="Sigla")
    private @Length(max=10) String sigla;
    @Length(max=18)
    @Caption(value="Telefone")
    private @Length(max=18) String telefone;
    @Email
    @Caption(value="Email")
    @Length(max=100)
    private @Email @Length(max=100) String email;
    @ManyToOne
    @NotAudited
    @NotFound(action=NotFoundAction.IGNORE)
    @ToModel(exclude={"localPai"})
    @JoinColumns(value={@JoinColumn(name="local_pai_codigo", referencedColumnName="codigo"), @JoinColumn(name="local_pai_entidade", referencedColumnName="entidade")})
    private Local localPai;
    @NotAudited
    @Formula(value="(select count(*) from locais l where l.local_pai_codigo = codigo and l.local_pai_entidade = entidade and l.ativo = 'S')")
    private Long quantidadeFilhos;
    @NotAudited
    @Convert(converter=BooleanToStringConverter.class)
    @Formula(value="(select case when  count(*) > 0 then 'S' else 'N' end from roteirolocal rl inner join roteiro r on r.id = rl.roteiro where rl.local = codigo and rl.entidade = entidade and r.id = rl.roteiro and r.ativo = 'S')")
    private boolean roteiroAtivo;

    public LocalPK getId() {
        return this.id;
    }

    public void setId(LocalPK id) {
        this.id = id;
    }

    public Local() {
    }

    public Local(LocalPK id) {
        this.id = id;
    }

    public Boolean possuiEmailPreenchido() {
        return this.getEmail() != null && !this.getEmail().isBlank();
    }

    public boolean getRoteiroAtivo() {
        return this.roteiroAtivo;
    }

    public void setRoteiroAtivo(boolean roteiroAtivo) {
        this.roteiroAtivo = roteiroAtivo;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public Diretoria getDiretoria() {
        return this.diretoria;
    }

    @Generated
    public Gerencia getGerencia() {
        return this.gerencia;
    }

    @Generated
    public Coordenadoria getCoordenadoria() {
        return this.coordenadoria;
    }

    @Generated
    public UnidadeOrcamentaria getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    @Generated
    public UsuarioResponsavel getResponsavel() {
        return this.responsavel;
    }

    @Generated
    public String getSigla() {
        return this.sigla;
    }

    @Generated
    public String getTelefone() {
        return this.telefone;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Local getLocalPai() {
        return this.localPai;
    }

    @Generated
    public Long getQuantidadeFilhos() {
        return this.quantidadeFilhos;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setDiretoria(Diretoria diretoria) {
        this.diretoria = diretoria;
    }

    @Generated
    public void setGerencia(Gerencia gerencia) {
        this.gerencia = gerencia;
    }

    @Generated
    public void setCoordenadoria(Coordenadoria coordenadoria) {
        this.coordenadoria = coordenadoria;
    }

    @Generated
    public void setUnidadeOrcamentaria(UnidadeOrcamentaria unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    @Generated
    public void setResponsavel(UsuarioResponsavel responsavel) {
        this.responsavel = responsavel;
    }

    @Generated
    public void setSigla(String sigla) {
        this.sigla = sigla;
    }

    @Generated
    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setLocalPai(Local localPai) {
        this.localPai = localPai;
    }

    @Generated
    public void setQuantidadeFilhos(Long quantidadeFilhos) {
        this.quantidadeFilhos = quantidadeFilhos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Local)) {
            return false;
        }
        Local other = (Local)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalPK this$id = this.getId();
        LocalPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Local;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Local(id=" + String.valueOf(this.getId()) + ")";
    }
}

