/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.domain.FluxoAssinante;
import br.com.elotech.protocolo.domain.support.AuditInfo;
import br.com.elotech.protocolo.domain.support.AuditListener;
import br.com.elotech.protocolo.domain.support.Auditable;
import br.com.elotech.protocolo.enums.TipoIntegracaoEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="fluxoassinatura")
@Audited
@EntityListeners(value={AuditListener.class})
public class FluxoAssinatura
implements Auditable,
EloEntity<UUID> {
    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private UUID id;
    @Length(max=100)
    @NotNull
    private @Length(max=100) @NotNull String descricao;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TipoIntegracaoEnum tipoIntegracao;
    @NotNull
    private Long entidade;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo = Boolean.TRUE;
    @NotAudited
    @OneToMany(mappedBy="fluxoAssinatura", cascade={CascadeType.ALL}, orphanRemoval=true)
    @MetaModelIgnore
    @OrderBy(value="sequencia")
    private List<FluxoAssinante> assinantes = new ArrayList();
    @Embedded
    private AuditInfo audit = new AuditInfo();

    @Generated
    public FluxoAssinatura() {
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public TipoIntegracaoEnum getTipoIntegracao() {
        return this.tipoIntegracao;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public List<FluxoAssinante> getAssinantes() {
        return this.assinantes;
    }

    @Generated
    public AuditInfo getAudit() {
        return this.audit;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setTipoIntegracao(TipoIntegracaoEnum tipoIntegracao) {
        this.tipoIntegracao = tipoIntegracao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setAssinantes(List<FluxoAssinante> assinantes) {
        this.assinantes = assinantes;
    }

    @Generated
    public void setAudit(AuditInfo audit) {
        this.audit = audit;
    }

    @Generated
    public String toString() {
        return "FluxoAssinatura(id=" + String.valueOf(this.getId()) + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FluxoAssinatura)) {
            return false;
        }
        FluxoAssinatura other = (FluxoAssinatura)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FluxoAssinatura;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

