/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.protocolo.domain.FluxoAssinatura;
import br.com.elotech.protocolo.domain.GrupoAssinante;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.support.AuditInfo;
import br.com.elotech.protocolo.domain.support.AuditListener;
import br.com.elotech.protocolo.domain.support.Auditable;
import br.com.elotech.protocolo.enums.TipoFluxoAssinanteEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.UUID;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Table(name="fluxoassinante")
@EntityListeners(value={AuditListener.class})
@Audited
public class FluxoAssinante
implements EloEntity<UUID>,
Auditable {
    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private UUID id;
    @NotNull
    private Long sequencia;
    private String condicao;
    @NotNull
    private String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean restringeCentroCusto = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean restringeUnidade = Boolean.FALSE;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TipoFluxoAssinanteEnum tipoFluxoAssinante;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fluxoassinatura_id")
    private FluxoAssinatura fluxoAssinatura;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="grupoassinante_id")
    @MetaModelIgnore
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private GrupoAssinante grupoAssinante;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usuario")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Usuario usuario;
    @Embedded
    private AuditInfo audit;

    @Generated
    public FluxoAssinante() {
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public String getCondicao() {
        return this.condicao;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getRestringeCentroCusto() {
        return this.restringeCentroCusto;
    }

    @Generated
    public Boolean getRestringeUnidade() {
        return this.restringeUnidade;
    }

    @Generated
    public TipoFluxoAssinanteEnum getTipoFluxoAssinante() {
        return this.tipoFluxoAssinante;
    }

    @Generated
    public FluxoAssinatura getFluxoAssinatura() {
        return this.fluxoAssinatura;
    }

    @Generated
    public GrupoAssinante getGrupoAssinante() {
        return this.grupoAssinante;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public AuditInfo getAudit() {
        return this.audit;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setCondicao(String condicao) {
        this.condicao = condicao;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setRestringeCentroCusto(Boolean restringeCentroCusto) {
        this.restringeCentroCusto = restringeCentroCusto;
    }

    @Generated
    public void setRestringeUnidade(Boolean restringeUnidade) {
        this.restringeUnidade = restringeUnidade;
    }

    @Generated
    public void setTipoFluxoAssinante(TipoFluxoAssinanteEnum tipoFluxoAssinante) {
        this.tipoFluxoAssinante = tipoFluxoAssinante;
    }

    @JsonIgnore
    @Generated
    public void setFluxoAssinatura(FluxoAssinatura fluxoAssinatura) {
        this.fluxoAssinatura = fluxoAssinatura;
    }

    @Generated
    public void setGrupoAssinante(GrupoAssinante grupoAssinante) {
        this.grupoAssinante = grupoAssinante;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setAudit(AuditInfo audit) {
        this.audit = audit;
    }

    @Generated
    public String toString() {
        return "FluxoAssinante(id=" + String.valueOf(this.getId()) + ", sequencia=" + this.getSequencia() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FluxoAssinante)) {
            return false;
        }
        FluxoAssinante other = (FluxoAssinante)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FluxoAssinante;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

