/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.protocolo.domain.Bairro;
import br.com.elotech.protocolo.domain.Cidade;
import br.com.elotech.protocolo.domain.Logradouro;
import br.com.elotech.protocolo.domain.UnidadeFederacao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="entidade")
public class Entidade
implements EloEntity<Long>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="entidade")
    @NotNull
    @EloSequence(sequenceName="s_protocoloentidade")
    private Long id;
    @Column(length=60)
    @Length(max=60)
    private @Length(max=60) String nome;
    @Column(length=15)
    @Length(max=15)
    private @Length(max=15) String cnpj;
    @Column(length=8)
    @Length(max=8)
    private @Length(max=8) String cep;
    private Long entidadePrincipal;
    @Column(name="tipoEntidade")
    private EntidadeTipo tipo;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String identificacaoTCE;
    @Basic(fetch=FetchType.LAZY)
    private byte[] brasao;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String telefone;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private UnidadeFederacao unidadefederacao;
    @Column(length=10)
    @Length(max=10)
    private @Length(max=10) String numero;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private Logradouro logradouro;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    private Bairro bairro;
    @ManyToOne
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private Cidade cidade;
    @Column(name="clienteelotechsn")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean clienteElotech;
    @Column(name="entidadeconsole")
    @Type(type="uuid-char")
    private UUID entidadeConsole;

    public Entidade() {
    }

    public Entidade(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public Long getEntidadePrincipal() {
        return this.entidadePrincipal;
    }

    public void setEntidadePrincipal(Long entidadePrincipal) {
        this.entidadePrincipal = entidadePrincipal;
    }

    public EntidadeTipo getTipo() {
        return this.tipo;
    }

    public void setTipo(EntidadeTipo tipo) {
        this.tipo = tipo;
    }

    public String getIdentificacaoTCE() {
        return this.identificacaoTCE;
    }

    public void setIdentificacaoTCE(String identificacaoTCE) {
        this.identificacaoTCE = identificacaoTCE;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public Boolean isPrincipal() {
        return this.id.equals(this.entidadePrincipal);
    }

    public static Entidade of(Long id) {
        Entidade entidade = new Entidade();
        entidade.setId(id);
        return entidade;
    }

    public byte[] getBrasao() {
        return this.brasao;
    }

    public void setBrasao(byte[] brasao) {
        this.brasao = brasao;
    }

    public UnidadeFederacao getUnidadefederacao() {
        return this.unidadefederacao;
    }

    public void setUnidadefederacao(UnidadeFederacao unidadefederacao) {
        this.unidadefederacao = unidadefederacao;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    public Bairro getBairro() {
        return this.bairro;
    }

    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public Boolean getClienteElotech() {
        return this.clienteElotech;
    }

    public void setClienteElotech(Boolean clienteElotech) {
        this.clienteElotech = clienteElotech;
    }

    public UUID getEntidadeConsole() {
        return this.entidadeConsole;
    }

    public void setEntidadeConsole(UUID entidadeConsole) {
        this.entidadeConsole = entidadeConsole;
    }

    @JsonIgnore
    public String getCidadeCompleta() {
        StringJoiner sj = new StringJoiner(" - ");
        Optional.ofNullable(this.getCidade()).map(Cidade::getDescricao).map(String::trim).filter(StringUtils::isNotBlank).ifPresent(sj::add);
        Optional.ofNullable(this.getUnidadefederacao()).map(UnidadeFederacao::getDescricao).map(String::trim).filter(StringUtils::isNotBlank).ifPresent(sj::add);
        sj.setEmptyValue("N\u00e3o declarada");
        return sj.toString();
    }

    @Generated
    public String toString() {
        return "Entidade(id=" + this.getId() + ", nome=" + this.getNome() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entidade)) {
            return false;
        }
        Entidade other = (Entidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Entidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

