/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.protocolo.domain.Bairro;
import br.com.elotech.protocolo.domain.Cidade;
import br.com.elotech.protocolo.domain.EnderecoPessoaPK;
import br.com.elotech.protocolo.domain.Logradouro;
import br.com.elotech.protocolo.domain.UnidadeFederacao;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="enderecopessoa")
@DynamicInsert
@DynamicUpdate
@Audited
public class EnderecoPessoa {
    @EmbeddedId
    private EnderecoPessoaPK pk = new EnderecoPessoaPK();
    @Length(max=100)
    private @Length(max=100) String endereco;
    @Length(max=10)
    @NotNull
    private @Length(max=10) @NotNull String numero;
    @Length(max=100)
    private @Length(max=100) String complemento;
    @Length(max=10)
    private @Length(max=10) String cep;
    @NotNull
    private EnderecoTipo tipoEndereco = EnderecoTipo.RESIDENCIAL;
    @ManyToOne
    @JoinColumn
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private Cidade cidade;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="logradouro")})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private Logradouro logradouro;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="bairro")})
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private Bairro bairro;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumns(value={@JoinColumn(name="unidadeFederacao")})
    private UnidadeFederacao uf;

    public EnderecoPessoaPK getPk() {
        return this.pk;
    }

    public EnderecoTipo getTipoEndereco() {
        return this.tipoEndereco;
    }

    public void setTipoEndereco(EnderecoTipo tipoEndereco) {
        this.tipoEndereco = tipoEndereco;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public UnidadeFederacao getUf() {
        return this.uf;
    }

    public void setUf(UnidadeFederacao uf) {
        this.uf = uf;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getCep() {
        return this.cep;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    public Bairro getBairro() {
        return this.bairro;
    }

    public String getEnderecoFormatado() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.defaultIfNull((Object)this.logradouro, l -> l.getDescricao() + " ", (String)"")).append(this.numero).append(StringUtils.defaultIfNull((Object)this.bairro, l -> ", " + l.getDescricao(), (String)"")).append(StringUtils.defaultIfNull((Object)this.cidade, c -> " - " + c.getDescricao(), (String)"")).append(StringUtils.defaultIfNull((Object)this.getUfFormatado(), u -> " - " + this.getUfFormatado(), (String)"")).append(StringUtils.defaultIfNull((Object)this.getCep(), c -> " CEP: " + this.getCep(), (String)""));
        return sb.toString();
    }

    public Long getId() {
        return this.pk.getCodigo();
    }

    public void setPk(EnderecoPessoaPK pk) {
        this.pk = pk;
    }

    public String getUfFormatado() {
        if (this.getUf() != null) {
            return this.uf.getId();
        }
        if (this.getCidade() != null && this.getCidade().getUf() != null) {
            return this.getCidade().getUf().getId();
        }
        return null;
    }

    @Generated
    public String toString() {
        return "EnderecoPessoa(pk=" + String.valueOf(this.getPk()) + ", endereco=" + this.getEndereco() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cep=" + this.getCep() + ", tipoEndereco=" + String.valueOf(this.getTipoEndereco()) + ", cidade=" + String.valueOf(this.getCidade()) + ", logradouro=" + String.valueOf(this.getLogradouro()) + ", bairro=" + String.valueOf(this.getBairro()) + ", uf=" + String.valueOf(this.getUf()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnderecoPessoa)) {
            return false;
        }
        EnderecoPessoa other = (EnderecoPessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EnderecoPessoaPK this$pk = this.getPk();
        EnderecoPessoaPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnderecoPessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnderecoPessoaPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }
}

