/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.protocolo.domain.support.AuditInfo;
import br.com.elotech.protocolo.domain.support.AuditListener;
import br.com.elotech.protocolo.domain.support.Auditable;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Audited
@EntityListeners(value={AuditListener.class})
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name="dataignorada")
public class DataIgnorada
implements Auditable,
Serializable,
EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="GEN_DATAIGNORAR", applyOnMerge=true)
    private Long id;
    @Length(max=200)
    @Caption(value="Descri\u00e7\u00e3o")
    @Column(name="descricao")
    private @Length(max=200) String descricao;
    @Caption(value="Ano")
    @Column(name="ano")
    private Long ano;
    @Caption(value="Data")
    @Column(name="data")
    private LocalDate data;
    @Caption(value="Dia da Semana")
    @Column(name="diasemana")
    private String diaSemana;
    @Caption(value="Fim de Semana")
    @Column(name="fimsemana")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean fimSemana;
    @Caption(value="Feriado")
    @Column(name="feriado")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean feriado;
    @Transient
    @Caption(value="Data Final")
    private LocalDate dataFinal;
    @Embedded
    private AuditInfo audit;

    @Generated
    public DataIgnorada() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getAno() {
        return this.ano;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public String getDiaSemana() {
        return this.diaSemana;
    }

    @Generated
    public Boolean getFimSemana() {
        return this.fimSemana;
    }

    @Generated
    public Boolean getFeriado() {
        return this.feriado;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public AuditInfo getAudit() {
        return this.audit;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setAno(Long ano) {
        this.ano = ano;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setDiaSemana(String diaSemana) {
        this.diaSemana = diaSemana;
    }

    @Generated
    public void setFimSemana(Boolean fimSemana) {
        this.fimSemana = fimSemana;
    }

    @Generated
    public void setFeriado(Boolean feriado) {
        this.feriado = feriado;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setAudit(AuditInfo audit) {
        this.audit = audit;
    }

    @Generated
    public String toString() {
        return "DataIgnorada(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", ano=" + this.getAno() + ", data=" + String.valueOf(this.getData()) + ", diaSemana=" + this.getDiaSemana() + ", fimSemana=" + this.getFimSemana() + ", feriado=" + this.getFeriado() + ", dataFinal=" + String.valueOf(this.getDataFinal()) + ", audit=" + String.valueOf(this.getAudit()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataIgnorada)) {
            return false;
        }
        DataIgnorada other = (DataIgnorada)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataIgnorada;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

