/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.ComprovanteEntregaDTO;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="COMPROVANTE_ENTREGA")
public class ComprovanteEntrega
implements EloEntity<Long> {
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @ManyToOne
    @JoinColumn
    private Entidade entidade;
    @ManyToOne
    @JoinColumn(name="tipo", referencedColumnName="codigo")
    private TipoProcesso tipo;
    @NotNull
    private Long numero;
    @NotNull
    private Long ano;
    @NotNull
    private LocalDate data;
    @Length(max=1000)
    @Caption(value="Justificativa")
    private @Length(max=1000) String justificativa;
    @Length(max=36)
    @Column(name="idprocesso")
    private @Length(max=36) String idProcesso;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Entregue")
    private Boolean entregue;
    @ManyToOne
    @JoinColumn(name="pessoa", referencedColumnName="codpessoa")
    @Caption(value="Pessoa")
    private Pessoa pessoa;

    public void setAttrValuesOfDTO(ComprovanteEntregaDTO dto) {
        this.setData(dto.getData());
        this.setJustificativa(dto.getJustificativa());
        this.setEntregue(dto.getEntregue());
    }

    @Generated
    public String toString() {
        return "ComprovanteEntrega(id=" + this.getId() + ", entidade=" + String.valueOf(this.getEntidade()) + ", tipo=" + String.valueOf(this.getTipo()) + ", numero=" + this.getNumero() + ", ano=" + this.getAno() + ", data=" + String.valueOf(this.getData()) + ", justificativa=" + this.getJustificativa() + ", idProcesso=" + this.getIdProcesso() + ", entregue=" + this.getEntregue() + ", pessoa=" + String.valueOf(this.getPessoa()) + ")";
    }

    @Generated
    public ComprovanteEntrega() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Entidade getEntidade() {
        return this.entidade;
    }

    @Generated
    public TipoProcesso getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public Long getAno() {
        return this.ano;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public String getJustificativa() {
        return this.justificativa;
    }

    @Generated
    public String getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Boolean getEntregue() {
        return this.entregue;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setTipo(TipoProcesso tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setAno(Long ano) {
        this.ano = ano;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Generated
    public void setIdProcesso(String idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setEntregue(Boolean entregue) {
        this.entregue = entregue;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComprovanteEntrega)) {
            return false;
        }
        ComprovanteEntrega other = (ComprovanteEntrega)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComprovanteEntrega;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

