/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Embeddable
public class CaixaPK
implements Serializable {
    private static final long serialVersionUID = 4480985862088540494L;
    @EloSequence(sequenceName="GEN_CAIXA_#{ano}")
    private Long codigo;
    @NotNull
    private Long ano = LocalDate.now().getYear();

    public CaixaPK() {
    }

    private CaixaPK(Long codigo, Long ano) {
        this.codigo = codigo;
        this.ano = ano;
    }

    public static CaixaPK of(Long codigo, Long ano) {
        return new CaixaPK(codigo, ano);
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public Long getAno() {
        return this.ano;
    }

    public void setAno(Long ano) {
        this.ano = ano;
    }

    public String getKey() {
        return String.format("?codigo=%d&ano=%d", this.codigo, this.ano);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaixaPK)) {
            return false;
        }
        CaixaPK other = (CaixaPK)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        Long this$ano = this.getAno();
        Long other$ano = other.getAno();
        return !(this$ano == null ? other$ano != null : !((Object)this$ano).equals(other$ano));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CaixaPK;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        Long $ano = this.getAno();
        result = result * 59 + ($ano == null ? 43 : ((Object)$ano).hashCode());
        return result;
    }
}

