/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.core.metamodel.annotation.ToModel;
import br.com.elotech.protocolo.domain.AssuntoArquivo;
import br.com.elotech.protocolo.domain.AssuntoDocumento;
import br.com.elotech.protocolo.domain.AssuntoEntidade;
import br.com.elotech.protocolo.domain.Roteiro;
import br.com.elotech.protocolo.domain.TipoProcesso;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="assunto")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@DynamicInsert
@DynamicUpdate
@Audited
public class Assunto
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="GEN_CODIGOASSUNTO")
    @Column(name="codigo")
    @Caption(value="Assunto")
    private Long id;
    @Caption(value="Descri\u00e7\u00e3o")
    @Length(max=250)
    @NotBlank
    private @Length(max=250) @NotBlank String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean assuntoInterno = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean possuiTaxas = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo = Boolean.TRUE;
    @Column(name="padrao_sigiloso")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean sigiloso = Boolean.TRUE;
    @Column(name="participantes_extras_externo")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean possuiParticipantesExtrasExterno = Boolean.FALSE;
    @Caption(value="Informa\u00e7\u00f5es Complementares")
    @Length(max=200)
    private @Length(max=200) String mensagem;
    @Caption(value="Complemento")
    @Length(max=1000)
    private @Length(max=1000) String complemento;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="id.assunto")
    @NotAudited
    private List<AssuntoDocumento> assuntoDocumento = new ArrayList();
    @OneToMany(mappedBy="assunto", cascade={CascadeType.ALL}, orphanRemoval=true)
    @NotAudited
    private List<AssuntoEntidade> assuntoEntidade = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    @NotAudited
    private Roteiro roteiro;
    private Integer prazoArquivamento;
    private String destinacaoFinal;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean obrigaDadosImovel;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean controlaTramitacao;
    @Caption(value="Ouvidoria")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ouvidoria = Boolean.FALSE;
    @Length(max=2000)
    @Column(name="termoaceite")
    private @Length(max=2000) String termoAceite;
    @Caption(value="Nota Explicativa")
    @Length(max=30000)
    @Column(name="notaexplicativa")
    private @Length(max=30000) String notaExplicativa;
    @Caption(value="Obriga Arquivos Assunto Interno")
    @Column(name="obriga_arq_assinterno")
    private Boolean obrigaArquivosAssuntoInterno = Boolean.FALSE;
    @Caption(value="Obriga Arquivos Assunto Externo")
    @Column(name="obriga_arq_assexterno")
    private Boolean obrigaArquivosAssuntoExterno = Boolean.FALSE;
    @Length(max=4000)
    @Caption(value="Termo de responsabilidade")
    @Column(name="termoresponsabilidade")
    private @Length(max=4000) String termoResponsabilidade;
    @Caption(value="Bloqueia Abertura Externa An\u00f4nima")
    @Column(name="bloqueiaaberturaexternaanonima")
    private Boolean bloqueiaAberturaExternaAnonima = Boolean.FALSE;
    @Caption(value="Obriga Endere\u00e7o Complementar")
    @Column(name="obrigaenderecocomplementar")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean obrigaEnderecoComplementar = Boolean.FALSE;
    @Caption(value="Denunciado")
    @Column(name="denunciado")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean denunciado = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean carregaRequerimentoExterno;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean exibeDadosImovel;
    @Length(max=4000)
    private @Length(max=4000) String requerimento;
    @Length(max=4000)
    private @Length(max=4000) String observacao;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToMany(mappedBy="assuntos")
    private Set<TipoProcesso> tipos = new HashSet();
    @OneToMany(mappedBy="assunto", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AssuntoArquivo> arquivos = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @NotAudited
    @ToModel(exclude={"assuntoPai"})
    @JoinColumn(name="assunto_pai")
    @NotFound(action=NotFoundAction.IGNORE)
    private Assunto assuntoPai;
    @Caption(value="Obriga Complemento do Assunto")
    @Column(name="obrigaComplementoAssunto")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean obrigaComplementoAssunto = Boolean.FALSE;
    @Caption(value="e-SIC")
    @Column(name="esic")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean esic = Boolean.FALSE;

    public Assunto(Long id) {
        this.id = id;
    }

    public Optional<AssuntoArquivo> buscarArquivoPorArquivoId(Long idArquivo) {
        return this.arquivos.stream().filter(assuntoArquivo -> assuntoArquivo.getArquivoId().equals(idArquivo)).findFirst();
    }

    public Boolean getControlaTramitacao() {
        return Boolean.TRUE.equals(this.controlaTramitacao);
    }

    public static Assunto of(Long id) {
        Assunto assunto = new Assunto();
        assunto.setId(id);
        return assunto;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getAssuntoInterno() {
        return this.assuntoInterno;
    }

    @Generated
    public Boolean getPossuiTaxas() {
        return this.possuiTaxas;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public Boolean getSigiloso() {
        return this.sigiloso;
    }

    @Generated
    public Boolean getPossuiParticipantesExtrasExterno() {
        return this.possuiParticipantesExtrasExterno;
    }

    @Generated
    public String getMensagem() {
        return this.mensagem;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public List<AssuntoDocumento> getAssuntoDocumento() {
        return this.assuntoDocumento;
    }

    @Generated
    public List<AssuntoEntidade> getAssuntoEntidade() {
        return this.assuntoEntidade;
    }

    @Generated
    public Roteiro getRoteiro() {
        return this.roteiro;
    }

    @Generated
    public Integer getPrazoArquivamento() {
        return this.prazoArquivamento;
    }

    @Generated
    public String getDestinacaoFinal() {
        return this.destinacaoFinal;
    }

    @Generated
    public Boolean getObrigaDadosImovel() {
        return this.obrigaDadosImovel;
    }

    @Generated
    public Boolean getOuvidoria() {
        return this.ouvidoria;
    }

    @Generated
    public String getTermoAceite() {
        return this.termoAceite;
    }

    @Generated
    public String getNotaExplicativa() {
        return this.notaExplicativa;
    }

    @Generated
    public Boolean getObrigaArquivosAssuntoInterno() {
        return this.obrigaArquivosAssuntoInterno;
    }

    @Generated
    public Boolean getObrigaArquivosAssuntoExterno() {
        return this.obrigaArquivosAssuntoExterno;
    }

    @Generated
    public String getTermoResponsabilidade() {
        return this.termoResponsabilidade;
    }

    @Generated
    public Boolean getBloqueiaAberturaExternaAnonima() {
        return this.bloqueiaAberturaExternaAnonima;
    }

    @Generated
    public Boolean getObrigaEnderecoComplementar() {
        return this.obrigaEnderecoComplementar;
    }

    @Generated
    public Boolean getDenunciado() {
        return this.denunciado;
    }

    @Generated
    public Boolean getCarregaRequerimentoExterno() {
        return this.carregaRequerimentoExterno;
    }

    @Generated
    public Boolean getExibeDadosImovel() {
        return this.exibeDadosImovel;
    }

    @Generated
    public String getRequerimento() {
        return this.requerimento;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Set<TipoProcesso> getTipos() {
        return this.tipos;
    }

    @Generated
    public List<AssuntoArquivo> getArquivos() {
        return this.arquivos;
    }

    @Generated
    public Assunto getAssuntoPai() {
        return this.assuntoPai;
    }

    @Generated
    public Boolean getObrigaComplementoAssunto() {
        return this.obrigaComplementoAssunto;
    }

    @Generated
    public Boolean getEsic() {
        return this.esic;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setAssuntoInterno(Boolean assuntoInterno) {
        this.assuntoInterno = assuntoInterno;
    }

    @Generated
    public void setPossuiTaxas(Boolean possuiTaxas) {
        this.possuiTaxas = possuiTaxas;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setSigiloso(Boolean sigiloso) {
        this.sigiloso = sigiloso;
    }

    @Generated
    public void setPossuiParticipantesExtrasExterno(Boolean possuiParticipantesExtrasExterno) {
        this.possuiParticipantesExtrasExterno = possuiParticipantesExtrasExterno;
    }

    @Generated
    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setAssuntoDocumento(List<AssuntoDocumento> assuntoDocumento) {
        this.assuntoDocumento = assuntoDocumento;
    }

    @Generated
    public void setAssuntoEntidade(List<AssuntoEntidade> assuntoEntidade) {
        this.assuntoEntidade = assuntoEntidade;
    }

    @Generated
    public void setRoteiro(Roteiro roteiro) {
        this.roteiro = roteiro;
    }

    @Generated
    public void setPrazoArquivamento(Integer prazoArquivamento) {
        this.prazoArquivamento = prazoArquivamento;
    }

    @Generated
    public void setDestinacaoFinal(String destinacaoFinal) {
        this.destinacaoFinal = destinacaoFinal;
    }

    @Generated
    public void setObrigaDadosImovel(Boolean obrigaDadosImovel) {
        this.obrigaDadosImovel = obrigaDadosImovel;
    }

    @Generated
    public void setControlaTramitacao(Boolean controlaTramitacao) {
        this.controlaTramitacao = controlaTramitacao;
    }

    @Generated
    public void setOuvidoria(Boolean ouvidoria) {
        this.ouvidoria = ouvidoria;
    }

    @Generated
    public void setTermoAceite(String termoAceite) {
        this.termoAceite = termoAceite;
    }

    @Generated
    public void setNotaExplicativa(String notaExplicativa) {
        this.notaExplicativa = notaExplicativa;
    }

    @Generated
    public void setObrigaArquivosAssuntoInterno(Boolean obrigaArquivosAssuntoInterno) {
        this.obrigaArquivosAssuntoInterno = obrigaArquivosAssuntoInterno;
    }

    @Generated
    public void setObrigaArquivosAssuntoExterno(Boolean obrigaArquivosAssuntoExterno) {
        this.obrigaArquivosAssuntoExterno = obrigaArquivosAssuntoExterno;
    }

    @Generated
    public void setTermoResponsabilidade(String termoResponsabilidade) {
        this.termoResponsabilidade = termoResponsabilidade;
    }

    @Generated
    public void setBloqueiaAberturaExternaAnonima(Boolean bloqueiaAberturaExternaAnonima) {
        this.bloqueiaAberturaExternaAnonima = bloqueiaAberturaExternaAnonima;
    }

    @Generated
    public void setObrigaEnderecoComplementar(Boolean obrigaEnderecoComplementar) {
        this.obrigaEnderecoComplementar = obrigaEnderecoComplementar;
    }

    @Generated
    public void setDenunciado(Boolean denunciado) {
        this.denunciado = denunciado;
    }

    @Generated
    public void setCarregaRequerimentoExterno(Boolean carregaRequerimentoExterno) {
        this.carregaRequerimentoExterno = carregaRequerimentoExterno;
    }

    @Generated
    public void setExibeDadosImovel(Boolean exibeDadosImovel) {
        this.exibeDadosImovel = exibeDadosImovel;
    }

    @Generated
    public void setRequerimento(String requerimento) {
        this.requerimento = requerimento;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @JsonIgnore
    @Generated
    public void setTipos(Set<TipoProcesso> tipos) {
        this.tipos = tipos;
    }

    @Generated
    public void setArquivos(List<AssuntoArquivo> arquivos) {
        this.arquivos = arquivos;
    }

    @Generated
    public void setAssuntoPai(Assunto assuntoPai) {
        this.assuntoPai = assuntoPai;
    }

    @Generated
    public void setObrigaComplementoAssunto(Boolean obrigaComplementoAssunto) {
        this.obrigaComplementoAssunto = obrigaComplementoAssunto;
    }

    @Generated
    public void setEsic(Boolean esic) {
        this.esic = esic;
    }

    @Generated
    public String toString() {
        return "Assunto(id=" + this.getId() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Assunto)) {
            return false;
        }
        Assunto other = (Assunto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Assunto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public Assunto() {
    }
}

