/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.protocolo.domain.support.AuditInfo;
import br.com.elotech.protocolo.domain.support.Auditable;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="assinatura_configuracao")
@Audited
public class AssinaturaConfiguracao
implements EloEntity<Long>,
Auditable {
    public static final String CERTIFICADO = "certificado";
    @Id
    @EloSequence(applyOnMerge=true)
    private Long id;
    @Column(name="tamanhofonte")
    private Long tamanhoFonte;
    private Long entidade;
    @Length(max=100)
    @Column(name="nomearquivocarimbo")
    private @Length(max=100) String nomeArquivoCarimbo;
    @Length(max=100)
    @Column(name="nomearquivocertificado")
    private @Length(max=100) String nomeArquivoCertificado;
    @Column(name="carimbo_arquivo_id")
    private Long carimboArquivoId;
    @Column(name="certificado_arquivo_id")
    private Long certificadoArquivoId;
    @Column(name="showcpf")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean showCpf;
    @Column(name="showdata")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean showData;
    @Column(name="showhora")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean showHora;
    @Length(max=500)
    private @Length(max=500) String decreto;
    @Length(max=100)
    @Column(name="aliascertificado")
    private @Length(max=100) String aliasCertificado;
    @Length(max=100)
    @Column(name="senhacertificado")
    private @Length(max=100) String senhaCertificado;
    @Length(max=500)
    @Column(name="urlautenticidade")
    private @Length(max=500) String urlAutenticidade;
    @Column(name="datainiciocolunas")
    private LocalDateTime dataInicioColunas;
    private Long quantidadeColunas;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean posicionaAssinatura;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean qrCodeNaAssinatura;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean informacoesNaLateral = true;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean aplicarProtecaoDocMdp = true;
    @Transient
    @NotAudited
    private EloArquivoDTO carimboArquivo;
    @Embedded
    private AuditInfo audit;

    public boolean isUsingQrCodeNaAssinatura() {
        return Boolean.TRUE.equals(this.qrCodeNaAssinatura) && StringUtils.isNotBlank((CharSequence)this.urlAutenticidade);
    }

    public void setArquivoDetails(String tipo, Long id, String nome) {
        if (StringUtils.isNotBlank((CharSequence)nome)) {
            nome = StringUtils.stripAccents((String)nome);
        }
        if (tipo.equals(CERTIFICADO)) {
            this.certificadoArquivoId = id;
            this.nomeArquivoCertificado = nome;
            return;
        }
        this.carimboArquivoId = id;
        this.nomeArquivoCarimbo = nome;
    }

    @Generated
    public AssinaturaConfiguracao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTamanhoFonte() {
        return this.tamanhoFonte;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getNomeArquivoCarimbo() {
        return this.nomeArquivoCarimbo;
    }

    @Generated
    public String getNomeArquivoCertificado() {
        return this.nomeArquivoCertificado;
    }

    @Generated
    public Long getCarimboArquivoId() {
        return this.carimboArquivoId;
    }

    @Generated
    public Long getCertificadoArquivoId() {
        return this.certificadoArquivoId;
    }

    @Generated
    public Boolean getShowCpf() {
        return this.showCpf;
    }

    @Generated
    public Boolean getShowData() {
        return this.showData;
    }

    @Generated
    public Boolean getShowHora() {
        return this.showHora;
    }

    @Generated
    public String getDecreto() {
        return this.decreto;
    }

    @Generated
    public String getAliasCertificado() {
        return this.aliasCertificado;
    }

    @Generated
    public String getSenhaCertificado() {
        return this.senhaCertificado;
    }

    @Generated
    public String getUrlAutenticidade() {
        return this.urlAutenticidade;
    }

    @Generated
    public LocalDateTime getDataInicioColunas() {
        return this.dataInicioColunas;
    }

    @Generated
    public Long getQuantidadeColunas() {
        return this.quantidadeColunas;
    }

    @Generated
    public Boolean getPosicionaAssinatura() {
        return this.posicionaAssinatura;
    }

    @Generated
    public Boolean getQrCodeNaAssinatura() {
        return this.qrCodeNaAssinatura;
    }

    @Generated
    public Boolean getInformacoesNaLateral() {
        return this.informacoesNaLateral;
    }

    @Generated
    public Boolean getAplicarProtecaoDocMdp() {
        return this.aplicarProtecaoDocMdp;
    }

    @Generated
    public EloArquivoDTO getCarimboArquivo() {
        return this.carimboArquivo;
    }

    @Generated
    public AuditInfo getAudit() {
        return this.audit;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTamanhoFonte(Long tamanhoFonte) {
        this.tamanhoFonte = tamanhoFonte;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setNomeArquivoCarimbo(String nomeArquivoCarimbo) {
        this.nomeArquivoCarimbo = nomeArquivoCarimbo;
    }

    @Generated
    public void setNomeArquivoCertificado(String nomeArquivoCertificado) {
        this.nomeArquivoCertificado = nomeArquivoCertificado;
    }

    @Generated
    public void setCarimboArquivoId(Long carimboArquivoId) {
        this.carimboArquivoId = carimboArquivoId;
    }

    @Generated
    public void setCertificadoArquivoId(Long certificadoArquivoId) {
        this.certificadoArquivoId = certificadoArquivoId;
    }

    @Generated
    public void setShowCpf(Boolean showCpf) {
        this.showCpf = showCpf;
    }

    @Generated
    public void setShowData(Boolean showData) {
        this.showData = showData;
    }

    @Generated
    public void setShowHora(Boolean showHora) {
        this.showHora = showHora;
    }

    @Generated
    public void setDecreto(String decreto) {
        this.decreto = decreto;
    }

    @Generated
    public void setAliasCertificado(String aliasCertificado) {
        this.aliasCertificado = aliasCertificado;
    }

    @Generated
    public void setSenhaCertificado(String senhaCertificado) {
        this.senhaCertificado = senhaCertificado;
    }

    @Generated
    public void setUrlAutenticidade(String urlAutenticidade) {
        this.urlAutenticidade = urlAutenticidade;
    }

    @Generated
    public void setDataInicioColunas(LocalDateTime dataInicioColunas) {
        this.dataInicioColunas = dataInicioColunas;
    }

    @Generated
    public void setQuantidadeColunas(Long quantidadeColunas) {
        this.quantidadeColunas = quantidadeColunas;
    }

    @Generated
    public void setPosicionaAssinatura(Boolean posicionaAssinatura) {
        this.posicionaAssinatura = posicionaAssinatura;
    }

    @Generated
    public void setQrCodeNaAssinatura(Boolean qrCodeNaAssinatura) {
        this.qrCodeNaAssinatura = qrCodeNaAssinatura;
    }

    @Generated
    public void setInformacoesNaLateral(Boolean informacoesNaLateral) {
        this.informacoesNaLateral = informacoesNaLateral;
    }

    @Generated
    public void setAplicarProtecaoDocMdp(Boolean aplicarProtecaoDocMdp) {
        this.aplicarProtecaoDocMdp = aplicarProtecaoDocMdp;
    }

    @Generated
    public void setCarimboArquivo(EloArquivoDTO carimboArquivo) {
        this.carimboArquivo = carimboArquivo;
    }

    @Generated
    public void setAudit(AuditInfo audit) {
        this.audit = audit;
    }

    @Generated
    public String toString() {
        return "AssinaturaConfiguracao(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssinaturaConfiguracao)) {
            return false;
        }
        AssinaturaConfiguracao other = (AssinaturaConfiguracao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssinaturaConfiguracao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

