/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.customchanges;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateIdentificadorProcessoArquivo
implements CustomTaskChange {
    private static final String UPDATE_ARQUIVO = "UPDATE PROTOCOLO_ARQUIVOS SET IDENTIFICADOR = ? WHERE IDARQUIVO = ?";
    private static final String SELECT_ARQUIVO = "SELECT IDARQUIVO FROM PROTOCOLO_ARQUIVOS WHERE IDENTIFICADOR IS NULL";
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateIdentificadorProcessoArquivo.class);

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Database database) throws CustomChangeException {
        JdbcConnection databaseConnection = (JdbcConnection)database.getConnection();
        try (Statement selectStatement = databaseConnection.createStatement();
             ResultSet rs = selectStatement.executeQuery(SELECT_ARQUIVO);
             PreparedStatement updateStatement = databaseConnection.prepareStatement(UPDATE_ARQUIVO);){
            while (rs.next()) {
                Long idArquivo = rs.getLong("IDARQUIVO");
                updateStatement.setString(1, UUID.randomUUID().toString());
                updateStatement.setLong(2, idArquivo);
                updateStatement.addBatch();
            }
            updateStatement.executeBatch();
            updateStatement.clearBatch();
        }
        catch (SQLException | DatabaseException e) {
            try {
                databaseConnection.rollback();
            }
            catch (DatabaseException e1) {
                LOGGER.error("Erro ao efetuar roolback no banco{}", (Object)e.getMessage(), (Object)e);
            }
            LOGGER.error("Erro ao conectar com o banco{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            try {
                databaseConnection.commit();
            }
            catch (DatabaseException e) {
                LOGGER.error("Erro ao efetuar commit no banco{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

