/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.protocolo.converter.AssuntoDTOConverter;
import br.com.elotech.protocolo.converter.SecretariaDTOConverter;
import br.com.elotech.protocolo.converter.UsuarioLocalDTOConverter;
import br.com.elotech.protocolo.converter.UsuarioModeloImpressaoDTOConverter;
import br.com.elotech.protocolo.converter.UsuarioTipoProcessoDTOConverter;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.Secretaria;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioModeloImpressao;
import br.com.elotech.protocolo.domain.UsuarioTipoProcesso;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.SecretariaDTO;
import br.com.elotech.protocolo.dto.UsuarioDTO;
import br.com.elotech.protocolo.dto.UsuarioLocalDTO;
import br.com.elotech.protocolo.dto.UsuarioModeloImpressaoDTO;
import br.com.elotech.protocolo.dto.UsuarioTipoProcessoDTO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UsuarioDTOConverter {
    public UsuarioDTO to(Usuario entity) {
        return this.to(entity, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
    }

    public UsuarioDTO to(Usuario entity, Boolean isMaskUser, Boolean isMaskCpf, Boolean isMaskCNPJ) {
        if (entity == null) {
            return null;
        }
        UsuarioDTO usuarioDTO = new UsuarioDTO();
        usuarioDTO.setId(entity.getId());
        usuarioDTO.setIdMask(entity.getCpf());
        usuarioDTO.setCpfMask(entity.getCpf());
        if (isMaskUser.booleanValue() && entity.getId().equals(entity.getCpf())) {
            usuarioDTO.setIdMask(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getCpf()));
        }
        usuarioDTO.setCpf(entity.getCpf());
        if (isMaskCpf.booleanValue() && CpfCnpjUtils.isCpf((String)entity.getCpf()).booleanValue()) {
            usuarioDTO.setCpfMask(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getCpf()));
        } else if (isMaskCNPJ.booleanValue() && !CpfCnpjUtils.isCpf((String)entity.getCpf()).booleanValue()) {
            usuarioDTO.setCpfMask(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getCpf()));
        }
        usuarioDTO.setNome(entity.getNome());
        usuarioDTO.setSenha(entity.getSenha());
        usuarioDTO.setLocal(entity.getLocal());
        usuarioDTO.setVisualiza(entity.getVisualiza());
        usuarioDTO.setNivelTramite(entity.getNivelTramite());
        usuarioDTO.setNivelAcesso(entity.getNivelAcesso());
        usuarioDTO.setNomeProg(entity.getNomeProg());
        usuarioDTO.setPadrao(entity.getPadrao());
        usuarioDTO.setVerificaMensagens(entity.getVerificaMensagens());
        usuarioDTO.setTempoVerificacao(entity.getTempoVerificacao());
        usuarioDTO.setAtivo(entity.getAtivo());
        usuarioDTO.setEmail(entity.getEmail());
        usuarioDTO.setBoAnexarArquivo(entity.getBoAnexarArquivo());
        usuarioDTO.setImprimePapeleta(entity.getImprimePapeleta());
        usuarioDTO.setExcluirArquivos(entity.getExcluirArquivos());
        usuarioDTO.setEditarProcessoTramitado(entity.getEditarProcessoTramitado());
        usuarioDTO.setUsuarioTipoProcesso(this.usuarioTipoProcessoListToUsuarioTipoProcessoDTOList(entity.getUsuarioTipoProcesso()));
        usuarioDTO.setUsuarioModeloImpressao(this.usuarioModeloImpressaoListToUsuarioModeloImpressaoDTOList(entity.getUsuarioModeloImpressao()));
        usuarioDTO.setSecretarias(this.secretariaSetToSecretariaDTOSet(entity.getSecretarias(), isMaskCpf, isMaskCNPJ));
        usuarioDTO.setAssuntos(this.assuntoSetToAssuntoDTOSet(entity.getAssuntos()));
        usuarioDTO.setUsuarioLocal(this.usuarioLocalSetToUsuarioLocalDTOList(entity.getUsuarioLocal()));
        usuarioDTO.setOuvidor(entity.getOuvidor());
        return usuarioDTO;
    }

    private List<UsuarioTipoProcessoDTO> usuarioTipoProcessoListToUsuarioTipoProcessoDTOList(List<UsuarioTipoProcesso> list) {
        if (list == null) {
            return null;
        }
        ArrayList<UsuarioTipoProcessoDTO> list1 = new ArrayList<UsuarioTipoProcessoDTO>(list.size());
        for (UsuarioTipoProcesso usuarioTipoProcesso : list) {
            list1.add(new UsuarioTipoProcessoDTOConverter().to(usuarioTipoProcesso));
        }
        return list1;
    }

    protected List<UsuarioModeloImpressaoDTO> usuarioModeloImpressaoListToUsuarioModeloImpressaoDTOList(List<UsuarioModeloImpressao> list) {
        if (list == null) {
            return null;
        }
        ArrayList<UsuarioModeloImpressaoDTO> list1 = new ArrayList<UsuarioModeloImpressaoDTO>(list.size());
        for (UsuarioModeloImpressao usuarioModeloImpressao : list) {
            list1.add(new UsuarioModeloImpressaoDTOConverter().to(usuarioModeloImpressao));
        }
        return list1;
    }

    protected Set<SecretariaDTO> secretariaSetToSecretariaDTOSet(Set<Secretaria> set, Boolean isMaskCpf, Boolean isMaskCNPJ) {
        HashSet<SecretariaDTO> set1 = new HashSet<SecretariaDTO>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (Secretaria secretaria : set) {
            set1.add(new SecretariaDTOConverter().to(secretaria, isMaskCpf, isMaskCNPJ));
        }
        return set1;
    }

    protected Set<AssuntoDTO> assuntoSetToAssuntoDTOSet(Set<Assunto> set) {
        HashSet<AssuntoDTO> set1 = new HashSet<AssuntoDTO>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (Assunto assunto : set) {
            set1.add(new AssuntoDTOConverter().to(assunto));
        }
        return set1;
    }

    protected List<UsuarioLocalDTO> usuarioLocalSetToUsuarioLocalDTOList(Set<UsuarioLocal> set) {
        if (set == null) {
            return null;
        }
        ArrayList<UsuarioLocalDTO> list = new ArrayList<UsuarioLocalDTO>(set.size());
        for (UsuarioLocal usuarioLocal : set) {
            list.add(new UsuarioLocalDTOConverter().to(usuarioLocal));
        }
        return list;
    }
}

