/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.converter.DTOConverter;
import br.com.elotech.protocolo.converter.AssuntoDTOConverter;
import br.com.elotech.protocolo.converter.ObservadorDTOConverter;
import br.com.elotech.protocolo.converter.SituacaoDTOConverter;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.ObservadorDTO;
import br.com.elotech.protocolo.dto.SituacaoDTO;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class TipoProcessoDTOConverter
implements DTOConverter<TipoProcesso, TipoProcessoDTO> {
    public TipoProcesso from(TipoProcessoDTO dto) {
        TipoProcesso tipoProcesso = new TipoProcesso();
        tipoProcesso.setId(dto.getId());
        tipoProcesso.setDescricao(dto.getDescricao());
        return tipoProcesso;
    }

    public TipoProcessoDTO to(TipoProcesso entity) {
        if (entity == null) {
            return null;
        }
        TipoProcessoDTO tipoProcessoDTO = new TipoProcessoDTO();
        tipoProcessoDTO.setId(entity.getId());
        tipoProcessoDTO.setDescricao(entity.getDescricao());
        tipoProcessoDTO.setDiasVencimento(entity.getDiasVencimento());
        tipoProcessoDTO.setCaminhoCapa(entity.getCaminhoCapa());
        tipoProcessoDTO.setCaminhoRequerimento(entity.getCaminhoRequerimento());
        tipoProcessoDTO.setCaminhoCapaAgrupamentoArquivo(entity.getCaminhoCapaAgrupamentoArquivo());
        tipoProcessoDTO.setCompra(entity.getCompra());
        tipoProcessoDTO.setAtivo(entity.getAtivo());
        tipoProcessoDTO.setSigiloso(entity.getSigiloso());
        tipoProcessoDTO.setImprimeComprovante(entity.getImprimeComprovante());
        tipoProcessoDTO.setImprimeCapaProcesso(entity.getImprimeCapaProcesso());
        tipoProcessoDTO.setImprimeEtiqueta(entity.getImprimeEtiqueta());
        tipoProcessoDTO.setTipoInterno(entity.getTipoInterno());
        tipoProcessoDTO.setComunicacaoInterna(entity.getComunicacaoInterna());
        tipoProcessoDTO.setPadraoFisico(entity.getPadraoFisico());
        tipoProcessoDTO.setTipoProcessoMp(entity.getTipoProcessoMp());
        tipoProcessoDTO.setPrioridadePadrao(entity.getPrioridadePadrao());
        tipoProcessoDTO.setConsultaExterna(entity.getConsultaExterna());
        tipoProcessoDTO.setUploadAnexoSemRestricao(entity.getUploadAnexoSemRestricao());
        return tipoProcessoDTO;
    }

    public TipoProcessoDTO toComplete(TipoProcesso entity) {
        if (entity == null) {
            return null;
        }
        TipoProcessoDTO tipoProcessoDTO = new TipoProcessoDTO();
        tipoProcessoDTO.setId(entity.getId());
        tipoProcessoDTO.setDescricao(entity.getDescricao());
        tipoProcessoDTO.setDiasVencimento(entity.getDiasVencimento());
        tipoProcessoDTO.setCaminhoCapa(entity.getCaminhoCapa());
        tipoProcessoDTO.setCaminhoRequerimento(entity.getCaminhoRequerimento());
        tipoProcessoDTO.setCaminhoCapaAgrupamentoArquivo(entity.getCaminhoCapaAgrupamentoArquivo());
        tipoProcessoDTO.setCompra(entity.getCompra());
        tipoProcessoDTO.setAtivo(entity.getAtivo());
        tipoProcessoDTO.setSigiloso(entity.getSigiloso());
        tipoProcessoDTO.setImprimeComprovante(entity.getImprimeComprovante());
        tipoProcessoDTO.setImprimeCapaProcesso(entity.getImprimeCapaProcesso());
        tipoProcessoDTO.setImprimeEtiqueta(entity.getImprimeEtiqueta());
        tipoProcessoDTO.setTipoInterno(entity.getTipoInterno());
        tipoProcessoDTO.setComunicacaoInterna(entity.getComunicacaoInterna());
        tipoProcessoDTO.setPadraoFisico(entity.getPadraoFisico());
        tipoProcessoDTO.setAssuntos(this.assuntoSetToAssuntoDTOSet(entity.getAssuntos()));
        tipoProcessoDTO.setTipoProcessoMp(entity.getTipoProcessoMp());
        tipoProcessoDTO.setSituacoes(this.situacaoSetToSituacaoDTOSet(entity.getSituacoes()));
        tipoProcessoDTO.setObservadores(this.obsSetToObsDTOSet(entity.getObservadores()));
        tipoProcessoDTO.setPrioridadePadrao(entity.getPrioridadePadrao());
        tipoProcessoDTO.setConsultaExterna(entity.getConsultaExterna());
        tipoProcessoDTO.setSituacaoPadrao(new SituacaoDTOConverter().to(entity.getSituacaoPadrao()));
        tipoProcessoDTO.setAssuntoPadrao(new AssuntoDTOConverter().to(entity.getAssuntoPadrao()));
        tipoProcessoDTO.setAssuntoFixo(Boolean.valueOf(Boolean.TRUE.equals(entity.getAssuntoFixo()) && Objects.nonNull(tipoProcessoDTO.getAssuntoPadrao())));
        tipoProcessoDTO.setUploadAnexoSemRestricao(entity.getUploadAnexoSemRestricao());
        return tipoProcessoDTO;
    }

    private Set<AssuntoDTO> assuntoSetToAssuntoDTOSet(Set<Assunto> set) {
        if (set == null) {
            return null;
        }
        AssuntoDTOConverter assuntoDTOConverter = new AssuntoDTOConverter();
        HashSet<AssuntoDTO> dto = new HashSet<AssuntoDTO>(this.getSize(set.size()));
        for (Assunto assunto : set) {
            dto.add(assuntoDTOConverter.to(assunto));
        }
        return dto;
    }

    private Set<SituacaoDTO> situacaoSetToSituacaoDTOSet(Set<Situacao> set) {
        if (set == null) {
            return null;
        }
        SituacaoDTOConverter situacaoDTOConverter = new SituacaoDTOConverter();
        HashSet<SituacaoDTO> dto = new HashSet<SituacaoDTO>(this.getSize(set.size()));
        for (Situacao situacao : set) {
            dto.add(situacaoDTOConverter.to(situacao));
        }
        return dto;
    }

    private Set<ObservadorDTO> obsSetToObsDTOSet(Set<Usuario> set) {
        if (set == null) {
            return null;
        }
        ObservadorDTOConverter converter = new ObservadorDTOConverter();
        HashSet<ObservadorDTO> dto = new HashSet<ObservadorDTO>(this.getSize(set.size()));
        for (Usuario usuario : set) {
            dto.add(converter.to(usuario));
        }
        return dto;
    }

    private int getSize(int size) {
        return Math.max((int)((float)size / 0.75f) + 1, 16);
    }
}

