/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.protocolo.converter.EntidadeDTOConverter;
import br.com.elotech.protocolo.converter.PessoaDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Secretaria;
import br.com.elotech.protocolo.domain.SecretariaPK;
import br.com.elotech.protocolo.dto.SecretariaDTO;

public class SecretariaDTOConverter {
    public SecretariaDTO to(Secretaria entity, Boolean isMaskCpf, Boolean isMaskCNPJ) {
        if (entity == null) {
            return null;
        }
        SecretariaDTO secretariaDTO = new SecretariaDTO();
        secretariaDTO.setEntidade(new EntidadeDTOConverter().to(this.secretariaIdEntidade(entity)));
        secretariaDTO.setId(this.secretariaIdId(entity));
        secretariaDTO.setDescricao(entity.getDescricao());
        secretariaDTO.setResponsavel(new PessoaDTOConverter().to(entity.getResponsavel(), isMaskCpf, isMaskCNPJ));
        secretariaDTO.setEmail(entity.getEmail());
        secretariaDTO.setSenhaEmail(entity.getSenhaEmail());
        return secretariaDTO;
    }

    private Long secretariaIdId(Secretaria secretaria) {
        if (secretaria == null) {
            return null;
        }
        SecretariaPK id = secretaria.getId();
        if (id == null) {
            return null;
        }
        Long id1 = id.getId();
        if (id1 == null) {
            return null;
        }
        return id1;
    }

    private Entidade secretariaIdEntidade(Secretaria secretaria) {
        if (secretaria == null) {
            return null;
        }
        SecretariaPK id = secretaria.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }
}

