/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.protocolo.converter.PessoaDTOConverter;
import br.com.elotech.protocolo.converter.TipoParticipanteDTOConverter;
import br.com.elotech.protocolo.domain.ProcessoInteressado;
import br.com.elotech.protocolo.domain.ProcessoInteressadoPK;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;

public class ProcessoInteressadoDTOConverter {
    public ProcessoInteressadoDTO to(ProcessoInteressado entity, Boolean isMaskCpf, Boolean isMaskCNPJ) {
        if (entity == null) {
            return null;
        }
        ProcessoInteressadoDTO processoInteressadoDTO = new ProcessoInteressadoDTO();
        processoInteressadoDTO.setCodigo(this.processoInteressadoIdCodigo(entity));
        processoInteressadoDTO.setLocalTrabalho(entity.getLocalTrabalho());
        processoInteressadoDTO.setPessoa(new PessoaDTOConverter().to(entity.getPessoa(), isMaskCpf, isMaskCNPJ));
        if (entity.getTipoInteresse() != null) {
            processoInteressadoDTO.setTipoInteresse(entity.getTipoInteresse().name());
        }
        processoInteressadoDTO.setTipoParticipante(new TipoParticipanteDTOConverter().to(entity.getTipoParticipante()));
        return processoInteressadoDTO;
    }

    private Long processoInteressadoIdCodigo(ProcessoInteressado processoInteressado) {
        if (processoInteressado == null) {
            return null;
        }
        ProcessoInteressadoPK id = processoInteressado.getId();
        if (id == null) {
            return null;
        }
        Long codigo = id.getCodigo();
        if (codigo == null) {
            return null;
        }
        return codigo;
    }
}

