/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.protocolo.converter.AssuntoDTOConverter;
import br.com.elotech.protocolo.converter.DadosProcessoMPDTOConverter;
import br.com.elotech.protocolo.converter.EntidadeDTOConverter;
import br.com.elotech.protocolo.converter.EscolaridadeDTOConverter;
import br.com.elotech.protocolo.converter.GrauSigiloDTOConverter;
import br.com.elotech.protocolo.converter.LocalDTOConverter;
import br.com.elotech.protocolo.converter.PessoaSimpleDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoArquivoDTOConverter;
import br.com.elotech.protocolo.converter.SituacaoDTOConverter;
import br.com.elotech.protocolo.converter.TipoProcessoSimpleDTOConverter;
import br.com.elotech.protocolo.converter.TramiteSimpleDTOConverter;
import br.com.elotech.protocolo.converter.UnidadeDTOConverter;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.ConfigLGPDCPFCNPJ;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.ProcessoEnxutoDTO;
import br.com.elotech.protocolo.dto.TramiteSimpleDTO;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessoEnxutoDTOConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoEnxutoDTOConverter.class);

    public ProcessoEnxutoDTO to(Processo entity, ConfigLGPDCPFCNPJ configLGPDCPFCNPJ, Boolean permiteAcesso, Boolean isOrdemCrescenteAnexo, Long quantidadeDiasAvisoAVencer) {
        if (entity == null) {
            return null;
        }
        log.debug("===================================PROCESSOEXUTODTO NUMERO{}=====================================", (Object)entity.getId().getKey());
        ProcessoEnxutoDTO processoDTO = new ProcessoEnxutoDTO();
        log.debug("Fun\u00e7\u00e3o");
        processoDTO.setFuncao(entity.getFuncao());
        log.debug("Tipo");
        processoDTO.setTipo(new TipoProcessoSimpleDTOConverter().to(entity.getId().getTipo()));
        log.debug("Ano");
        processoDTO.setAno(this.processoIdAno(entity));
        log.debug("IdNumero");
        processoDTO.setNumero(this.processoIdNumero(entity));
        log.debug("Endereco");
        processoDTO.setEndereco(entity.getEndereco());
        log.debug("Lote");
        processoDTO.setLote(entity.getData());
        log.debug("BairroAux");
        processoDTO.setBairroAux(entity.getBairroAux());
        log.debug("Entidade");
        processoDTO.setEntidade(new EntidadeDTOConverter().to(entity.getId().getEntidade()));
        log.debug("NumeroEndereco");
        processoDTO.setNumeroEndereco(entity.getNumeroEndereco());
        log.debug("UF");
        processoDTO.setUf(entity.getUf());
        log.debug("CidadeAux");
        processoDTO.setCidadeAux(entity.getCidadeAux());
        log.debug("SenhaInternet");
        processoDTO.setSenhaInternet(entity.getSenhaInternet());
        log.debug("Pessoa");
        processoDTO.setPessoa(new PessoaSimpleDTOConverter().to(entity.getPessoa(), configLGPDCPFCNPJ.getEscondeNumeroCPF(), configLGPDCPFCNPJ.getEscondeNumeroCNPJ()));
        log.debug("Data Processo");
        processoDTO.setDataProcesso(entity.getDataProcesso());
        log.debug("Situacao");
        processoDTO.setSituacao(new SituacaoDTOConverter().to(entity.getSituacao()));
        log.debug("Assunto");
        processoDTO.setAssunto(new AssuntoDTOConverter().to(entity.getAssunto()));
        log.debug("Complemento");
        processoDTO.setComplementoAssunto(entity.getComplementoAssunto());
        log.debug("Email");
        processoDTO.setEmail(entity.getEmail());
        log.debug("Celular");
        processoDTO.setCelular(entity.getCelular());
        log.debug("Local Origem");
        processoDTO.setLocalOrigem(new LocalDTOConverter().to(entity.getLocalOrigem()));
        log.debug("Unidade");
        processoDTO.setUnidade(new UnidadeDTOConverter().to(entity.getUnidade()));
        log.debug("Local Destino");
        processoDTO.setLocalDestino(new LocalDTOConverter().to(entity.getLocalDestino()));
        log.debug("Local Atual");
        processoDTO.setLocalAtual(new LocalDTOConverter().to(entity.getLocalAtual()));
        log.debug("Digitacao");
        boolean mostraDigitacao = Boolean.TRUE.equals(permiteAcesso) || !Boolean.TRUE.equals(entity.getSigiloso());
        processoDTO.setDigitacao(mostraDigitacao ? entity.getDigitacao() : "(Sem permiss\u00e3o para visualiza\u00e7\u00e3o)");
        log.debug("UsuarioRegistro");
        processoDTO.setUsuarioRegistro(entity.getUsuarioRegistro());
        log.debug("Solicitacao");
        processoDTO.setSolicitacaoJson(entity.getSolicitacaoJson());
        log.debug("Zona");
        processoDTO.setZona(entity.getZona());
        log.debug("Quadra");
        processoDTO.setQuadra(entity.getQuadra());
        log.debug("Cadastro");
        processoDTO.setCadastro(entity.getCadastro());
        log.debug("Sigiloso");
        processoDTO.setSigiloso(entity.getSigiloso());
        log.debug("Data de Registro");
        processoDTO.setDataRegistro(entity.getDataRegistro());
        log.debug("Tramites");
        processoDTO.setTramites(this.tramiteListToTramiteDTOList(entity.getTramites()));
        log.debug("Busca usuario resp");
        Usuario usuarioResp = entity.getUsuarioResponsavelTramite();
        log.debug("Formata Resp");
        String idUsrMask = null;
        if (Objects.nonNull(usuarioResp) && Objects.nonNull(usuarioResp.getId())) {
            idUsrMask = configLGPDCPFCNPJ.getEscondeNumeroLogin() != false && usuarioResp.getId().equals(usuarioResp.getCpf()) ? CpfCnpjUtils.getMaskCnpjCpf((String)usuarioResp.getId()) : usuarioResp.getId();
        }
        log.debug("UsuarioPermissaoDTO");
        UsuarioPermissaoLocalDTO usuarioPermissaoLocalDTO = Objects.isNull(usuarioResp) ? new UsuarioPermissaoLocalDTO() : UsuarioPermissaoLocalDTO.builder().ativo(usuarioResp.getAtivo()).alteraTodosProc(UsuarioUtils.isAlteraTodosProc((Usuario)usuarioResp, (Processo)entity)).loginUsuario(usuarioResp.getId()).nomeUsuario(usuarioResp.getNome()).loginUsuarioMask(idUsrMask).build();
        log.debug("ResponsavelTramite");
        processoDTO.setUsuarioResponsavelTramite(usuarioPermissaoLocalDTO);
        log.debug("Arquivos");
        processoDTO.setArquivos(this.processoArquivoListToProcessoArquivoDTOList(entity.getArquivos(), configLGPDCPFCNPJ.getEscondeNumeroCPF(), configLGPDCPFCNPJ.getEscondeNumeroCNPJ(), configLGPDCPFCNPJ.getEscondeNumeroLogin(), isOrdemCrescenteAnexo));
        log.debug("Observacao");
        processoDTO.setObservacao(entity.getObservacao());
        log.debug("ProcessoReferencia");
        processoDTO.setProcessoReferencia(entity.getProcessoReferencia());
        log.debug("ProcessoExterno");
        processoDTO.setExterno(entity.getExterno());
        log.debug("Paralisado");
        processoDTO.setParalisado(entity.getParalisado());
        log.debug("Sigilo");
        processoDTO.setGrauSigilo(new GrauSigiloDTOConverter().to(entity.getGrauSigilo()));
        log.debug("UUID");
        processoDTO.setUuid(entity.getUuid());
        log.debug("CEP");
        processoDTO.setCep(entity.getCep());
        log.debug("Complemento");
        processoDTO.setComplemento(entity.getComplemento());
        log.debug("IdProcessoTaxa");
        processoDTO.setIdProcessoTaxa(entity.getIdProcessoTaxa());
        log.debug("BoletoPago");
        processoDTO.setBoletoPago(entity.getBoletoPago());
        log.debug("ProcessoAvaliado");
        processoDTO.setProcessoAvaliado(entity.getProcessoAvaliado());
        log.debug("Ouvidoria");
        processoDTO.setOuvidoria(entity.getOuvidoria());
        log.debug("OuvidoriaAnonima");
        processoDTO.setOuvidoriaAnonima(entity.getOuvidoriaAnonima());
        log.debug("UltimaAtualizacao");
        processoDTO.setUltimaAtualizacao(entity.getUltimaAtualizacao());
        log.debug("Escolaridade");
        processoDTO.setEscolaridade(new EscolaridadeDTOConverter().to(entity.getEscolaridade()));
        log.debug("ProcessoVencido");
        processoDTO.setProcessoVencido(entity.getProcessoVencido());
        log.debug("Fechado");
        processoDTO.setFechado(entity.getFechado());
        log.debug("Sexo");
        processoDTO.setSexo(entity.getSexo());
        log.debug("NumeroAntigo");
        processoDTO.setNumeroAntigo(entity.getNumeroAntigo());
        log.debug("PermiteAcessoUsuarioLogado");
        processoDTO.setPermiteAcessoUsuarioLogado(entity.getPermiteAcessoUsuarioLogado());
        log.debug("Prioridade");
        processoDTO.setPrioridade(entity.getPrioridade());
        log.debug("Nota");
        processoDTO.setNota(entity.getNota());
        log.debug("Observacao");
        processoDTO.setNotaObservacao(entity.getNotaObservacao());
        log.debug("PrevisaoConclusao");
        processoDTO.setPrevisaoConclusao(entity.getPrevisaoConclusao());
        log.debug("ProcessoFisico");
        processoDTO.setProcessoFisico(entity.getProcessoFisico());
        log.debug("TramitaEntreEntidades");
        processoDTO.setTramitaEntreEntidades(entity.getTramitaEntreEntidades());
        log.debug("ProcessoDesclassificacao");
        processoDTO.setPrazoDesclassificacao(entity.getPrazoDesclassificacao());
        log.debug("Requerimento");
        processoDTO.setRequerimentoTributos(entity.getRequerimentoTributos());
        log.debug("UsuarioAlteracao");
        processoDTO.setUsuarioAlteracao(entity.getUsuarioAlteracao());
        log.debug("TipoOuvidoria");
        processoDTO.setTipoOuvidoria(entity.getTipoOuvidoria());
        log.debug("Roteiro");
        processoDTO.setRoteiro(entity.getRoteiro());
        log.debug("PermiteUsuarioLogado");
        processoDTO.setPermiteAcessoUsuarioLogado(permiteAcesso.booleanValue());
        log.debug("processoMP");
        processoDTO.setProcessoMp(DadosProcessoMPDTOConverter.to((Processo)entity));
        log.debug("AssinaturaPendente");
        processoDTO.setPossuiAssinaturaPendente(entity.getPossuiAssinaturaPendente());
        log.debug("AssinaturaRejeitada");
        processoDTO.setPossuiAssinaturaRejeitada(entity.getPossuiAssinaturaRejeitada());
        log.debug("IntegracaoAssinatura");
        if (!entity.getArquivos().isEmpty()) {
            log.debug("Possui Arquivo Anexo");
            processoDTO.setPossuiArquivoAnexo(Boolean.TRUE);
        }
        if (!entity.getInteressados().isEmpty()) {
            log.debug("Possui Interessado");
            processoDTO.setPossuiInteressado(Boolean.TRUE);
        }
        if (entity.hasFilaIntegracaoAssinatura()) {
            processoDTO.setFilaIntegracaoAssinatura(entity.getFilaIntegracaoAssinatura());
        }
        entity.getUltimoTramite().ifPresent(ultimoTramite -> processoDTO.setPossuiHistoricoUltimoTramite(Boolean.valueOf(!ultimoTramite.getHistoricos().isEmpty())));
        Optional.ofNullable(entity.getPrevisaoConclusao()).ifPresent(previsaoConclusao -> {
            Long diferencaEmDias = ChronoUnit.DAYS.between(LocalDate.now(), (Temporal)previsaoConclusao);
            processoDTO.setAVencer(Boolean.valueOf(diferencaEmDias >= 0L && diferencaEmDias <= quantidadeDiasAvisoAVencer));
        });
        log.debug("key");
        processoDTO.setId(entity.getId().getKey());
        log.debug("FIM PROCESSO ENXUTO DTO");
        return processoDTO;
    }

    private List<TramiteSimpleDTO> tramiteListToTramiteDTOList(List<Tramite> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TramiteSimpleDTO> list1 = new ArrayList<TramiteSimpleDTO>(list.size());
        for (Tramite tramite : list) {
            list1.add(new TramiteSimpleDTOConverter().to(tramite));
        }
        return list1;
    }

    private Long processoIdNumero(Processo processo) {
        if (Objects.isNull(processo.getId())) {
            return null;
        }
        return processo.getId().getNumero();
    }

    private Long processoIdAno(Processo processo) {
        if (Objects.isNull(processo.getId())) {
            return null;
        }
        return processo.getId().getAno();
    }

    private List<ProcessoArquivoDTO> processoArquivoListToProcessoArquivoDTOList(List<ProcessoArquivo> list, Boolean isMaskCpf, Boolean isMaskCNPJ, Boolean isMaskUser, Boolean isOrdemCrescenteAnexo) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoArquivoDTO> list1 = new ArrayList<ProcessoArquivoDTO>(list.size());
        for (ProcessoArquivo processoArquivo : list) {
            list1.add(new ProcessoArquivoDTOConverter().to(processoArquivo, isMaskCpf, isMaskCNPJ, isMaskUser));
        }
        if (Boolean.TRUE.equals(isOrdemCrescenteAnexo)) {
            list1.sort(Comparator.comparing(ProcessoArquivoDTO::getOrdem));
        } else {
            list1.sort(Comparator.comparing(ProcessoArquivoDTO::getOrdem).reversed());
        }
        return list1;
    }
}

