/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.protocolo.converter.AssuntoDTOConverter;
import br.com.elotech.protocolo.converter.DadosProcessoMPDTOConverter;
import br.com.elotech.protocolo.converter.EntidadeDTOConverter;
import br.com.elotech.protocolo.converter.EscolaridadeDTOConverter;
import br.com.elotech.protocolo.converter.GrauSigiloDTOConverter;
import br.com.elotech.protocolo.converter.LocalDTOConverter;
import br.com.elotech.protocolo.converter.PessoaDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoAndamentoDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoAnexoDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoArquivoDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoInteressadoDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoObservadorDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoObservadorExternoDTOConverter;
import br.com.elotech.protocolo.converter.SituacaoDTOConverter;
import br.com.elotech.protocolo.converter.TipoProcessoSimpleDTOConverter;
import br.com.elotech.protocolo.converter.TramiteDTOConverter;
import br.com.elotech.protocolo.converter.UnidadeDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.domain.ProcessoAnexo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoInteressado;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoSimpleDTO;
import br.com.elotech.protocolo.dto.ProcessoAnexoDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import br.com.elotech.protocolo.dto.ProcessoObservadorExternoDTO;
import br.com.elotech.protocolo.dto.ProcessoReferenciaDTO;
import br.com.elotech.protocolo.dto.TipoProcessoSimpleDTO;
import br.com.elotech.protocolo.dto.TramiteDTO;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import br.com.elotech.protocolo.service.util.ProcessoReferenciaDTOBuilder;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessoDTOConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoDTOConverter.class);

    public ProcessoDTO to(Processo entity, Boolean isMaskCpf, Boolean isMaskCnpj, Boolean isMaskUser, Boolean isOrdemCrescenteAnexo, Boolean isOrdemDecrescenteApenasCampoCalculado) {
        return this.to(entity, isMaskCpf, isMaskCnpj, isMaskUser, Boolean.TRUE, isOrdemCrescenteAnexo, isOrdemDecrescenteApenasCampoCalculado);
    }

    public ProcessoDTO to(Processo entity, Boolean isMaskCpf, Boolean isMaskCnpj, Boolean isMaskUser, Boolean permiteAcesso, Boolean isOrdemCrescenteAnexo, Boolean isOrdemDecrescenteApenasCampoCalculado) {
        if (entity == null) {
            return null;
        }
        log.debug("=======================Inicio converter processo:{}=======================", (Object)entity.getId().getKey());
        ProcessoDTO processoDTO = new ProcessoDTO();
        log.debug("Responsavel tramite");
        processoDTO.setUsuarioResponsavelTramite(this.usuarioToUsuarioPermissaoLocalDTO(entity.getUsuarioResponsavelTramite(), entity, isMaskUser));
        log.debug("funcao");
        processoDTO.setFuncao(entity.getFuncao());
        log.debug("tipo");
        processoDTO.setTipo(new TipoProcessoSimpleDTOConverter().to(this.processoIdTipo(entity)));
        log.debug("ano");
        processoDTO.setAno(this.processoIdAno(entity));
        log.debug("numero");
        processoDTO.setNumero(this.processoIdNumero(entity));
        log.debug("endereco");
        processoDTO.setEndereco(entity.getEndereco());
        log.debug("Lote");
        processoDTO.setLote(entity.getData());
        log.debug("Bairro");
        processoDTO.setBairroAux(entity.getBairroAux());
        log.debug("Entidade");
        processoDTO.setEntidade(new EntidadeDTOConverter().to(this.processoIdEntidade(entity)));
        log.debug("NumeroEndereco");
        processoDTO.setNumeroEndereco(entity.getNumeroEndereco());
        log.debug("Uf");
        processoDTO.setUf(entity.getUf());
        log.debug("CidadeAux");
        processoDTO.setCidadeAux(entity.getCidadeAux());
        log.debug("Senha");
        processoDTO.setSenhaInternet(entity.getSenhaInternet());
        log.debug("Pessoa");
        processoDTO.setPessoa(new PessoaDTOConverter().to(entity.getPessoa(), isMaskCpf, isMaskCnpj));
        log.debug("DataProcesso");
        processoDTO.setDataProcesso(entity.getDataProcesso());
        log.debug("Situacao");
        processoDTO.setSituacao(new SituacaoDTOConverter().to(entity.getSituacao()));
        log.debug("Assunto");
        processoDTO.setAssunto(new AssuntoDTOConverter().to(entity.getAssunto()));
        log.debug("Complemento");
        processoDTO.setComplementoAssunto(entity.getComplementoAssunto());
        log.debug("Email");
        processoDTO.setEmail(entity.getEmail());
        log.debug("Celular");
        processoDTO.setCelular(entity.getCelular());
        log.debug("LocalOrigem");
        processoDTO.setLocalOrigem(new LocalDTOConverter().to(entity.getLocalOrigem()));
        log.debug("Unidade");
        processoDTO.setUnidade(new UnidadeDTOConverter().to(entity.getUnidade()));
        log.debug("LocalDestino");
        processoDTO.setLocalDestino(new LocalDTOConverter().to(entity.getLocalDestino()));
        log.debug("LocalAtual");
        processoDTO.setLocalAtual(new LocalDTOConverter().to(entity.getLocalAtual()));
        log.debug("Digitacao");
        processoDTO.setDigitacao(entity.getDigitacao());
        log.debug("UsuarioRegistro");
        processoDTO.setUsuarioRegistro(entity.getUsuarioRegistro());
        log.debug("Solicitacao");
        processoDTO.setSolicitacaoJson(entity.getSolicitacaoJson());
        log.debug("Zona");
        processoDTO.setZona(entity.getZona());
        log.debug("Quadra");
        processoDTO.setQuadra(entity.getQuadra());
        log.debug("Cadastro");
        processoDTO.setCadastro(entity.getCadastro());
        log.debug("Sigiloso");
        processoDTO.setSigiloso(entity.getSigiloso());
        log.debug("DataRegistro");
        processoDTO.setDataRegistro(entity.getDataRegistro());
        log.debug("Tramites");
        processoDTO.setTramites(this.tramiteListToTramiteDTOList(entity.getTramites()));
        log.debug("Anexos");
        processoDTO.setProcessosAnexos(this.processoAnexoListToProcessoAnexoDTOList(entity.getProcessosAnexos()));
        log.debug("Arquivos");
        processoDTO.setArquivos(this.processoArquivoListToProcessoArquivoDTOList(entity.getArquivos(), isMaskCpf, isMaskCnpj, isMaskUser, isOrdemCrescenteAnexo, isOrdemDecrescenteApenasCampoCalculado));
        log.debug("Interessados");
        processoDTO.setInteressados(this.processoInteressadoListToProcessoInteressadoDTOList(entity.getInteressados(), isMaskCpf, isMaskCnpj));
        log.debug("Observacao");
        processoDTO.setObservacao(entity.getObservacao());
        log.debug("Referencia");
        processoDTO.setProcessoReferencia(entity.getProcessoReferencia());
        log.debug("Externo");
        processoDTO.setExterno(entity.getExterno());
        log.debug("Paralisado");
        processoDTO.setParalisado(entity.getParalisado());
        log.debug("GrauSigilo");
        processoDTO.setGrauSigilo(new GrauSigiloDTOConverter().to(entity.getGrauSigilo()));
        log.debug("uuid");
        processoDTO.setUuid(entity.getUuid());
        log.debug("CEP");
        processoDTO.setCep(entity.getCep());
        log.debug("Complemento");
        processoDTO.setComplemento(entity.getComplemento());
        log.debug("IdProcessoTaxa");
        processoDTO.setIdProcessoTaxa(entity.getIdProcessoTaxa());
        log.debug("BoletoPago");
        processoDTO.setBoletoPago(entity.getBoletoPago());
        log.debug("ProcessoValidado");
        processoDTO.setProcessoAvaliado(entity.getProcessoAvaliado());
        log.debug("Ouvidoria");
        processoDTO.setOuvidoria(entity.getOuvidoria());
        log.debug("Ouvidoria Anonima");
        processoDTO.setOuvidoriaAnonima(entity.getOuvidoriaAnonima());
        log.debug("UltimaAtualizacao");
        processoDTO.setUltimaAtualizacao(entity.getUltimaAtualizacao());
        log.debug("Escolaridade");
        processoDTO.setEscolaridade(new EscolaridadeDTOConverter().to(entity.getEscolaridade()));
        log.debug(" ProcessoVencido");
        processoDTO.setProcessoVencido(entity.getProcessoVencido());
        log.debug("Fechado");
        processoDTO.setFechado(entity.getFechado());
        log.debug("Sexo");
        processoDTO.setSexo(entity.getSexo());
        log.debug("NumeroAntigo");
        processoDTO.setNumeroAntigo(entity.getNumeroAntigo());
        log.debug("UsuarioLogado");
        processoDTO.setPermiteAcessoUsuarioLogado(entity.getPermiteAcessoUsuarioLogado());
        log.debug("Prioridade");
        processoDTO.setPrioridade(entity.getPrioridade());
        log.debug("Nota");
        processoDTO.setNota(entity.getNota());
        log.debug("Nota observacao");
        processoDTO.setNotaObservacao(entity.getNotaObservacao());
        log.debug("PrevisaoConclusao");
        processoDTO.setPrevisaoConclusao(entity.getPrevisaoConclusao());
        log.debug("Andamentos");
        processoDTO.setAndamentos(this.processoAndamentoListToProcessoAndamentoDTOList(entity.getAndamentos(), isMaskUser));
        log.debug("ProcessoFisico");
        processoDTO.setProcessoFisico(entity.getProcessoFisico());
        log.debug("Tramita Entre Entidades");
        processoDTO.setTramitaEntreEntidades(entity.getTramitaEntreEntidades());
        log.debug("Classificacao");
        processoDTO.setPrazoDesclassificacao(entity.getPrazoDesclassificacao());
        log.debug("Fundamento Legal");
        processoDTO.setFundamentacaoLegal(entity.getFundamentacaoLegal());
        log.debug("RequerimentoTributos");
        processoDTO.setRequerimentoTributos(entity.getRequerimentoTributos());
        log.debug("ProcessoMP");
        processoDTO.setProcessoMp(DadosProcessoMPDTOConverter.to((Processo)entity));
        log.debug("Observadores");
        processoDTO.getObservadores().addAll(entity.getObservadores().stream().map(obs -> new ProcessoObservadorDTOConverter().to(obs)).collect(Collectors.toList()));
        log.debug("Procedimento Origem");
        processoDTO.setProcedimentoOrigem(this.buildProcedimentoOrigem(entity));
        log.debug("Observadores externos");
        processoDTO.getObservadoresExternos().addAll(this.buildObservadorExterno(entity));
        log.debug("UsuarioAlteracao");
        processoDTO.setUsuarioAlteracao(entity.getUsuarioAlteracao());
        log.debug("Tipo ouvidoria");
        processoDTO.setTipoOuvidoria(entity.getTipoOuvidoria());
        log.debug("PermiteAcessoUsuarioLogado");
        processoDTO.setPermiteAcessoUsuarioLogado(permiteAcesso.booleanValue());
        log.debug("Roteiro");
        processoDTO.setRoteiro(entity.getRoteiro());
        log.debug("Fila Integeracao");
        if (entity.hasFilaIntegracaoAssinatura()) {
            processoDTO.setFilaIntegracaoAssinatura(entity.getFilaIntegracaoAssinatura());
        }
        log.debug("idkey");
        processoDTO.setId(entity.getId().getKey());
        log.debug("bloqueioAnexoExterno");
        processoDTO.setBloqueioAnexoExterno(entity.getBloqueioAnexoExterno());
        log.debug("Denunciado");
        processoDTO.setDenunciado(entity.getDenunciado());
        log.debug("FIM CONVERTER");
        return processoDTO;
    }

    public Processo from(ProcessoDTO dto) {
        if (dto == null) {
            return null;
        }
        ProcessoPK processoPK = ProcessoPK.of((Entidade)new EntidadeDTOConverter().from(dto.getEntidade()), (TipoProcesso)new TipoProcessoSimpleDTOConverter().from(dto.getTipo()), (Long)dto.getNumero(), (Long)dto.getAno());
        Processo processo = Processo.of((ProcessoPK)processoPK);
        processo.setAssunto(new AssuntoDTOConverter().from(dto.getAssunto()));
        return processo;
    }

    protected List<ProcessoAndamentoSimpleDTO> processoAndamentoListToProcessoAndamentoDTOList(List<ProcessoAndamento> list, Boolean isMaskUser) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoAndamentoSimpleDTO> list1 = new ArrayList<ProcessoAndamentoSimpleDTO>(list.size());
        for (ProcessoAndamento processoAndamento : list) {
            list1.add(new ProcessoAndamentoDTOConverter().toSimple(processoAndamento, isMaskUser));
        }
        return list1;
    }

    private UsuarioPermissaoLocalDTO usuarioToUsuarioPermissaoLocalDTO(Usuario usuario, Processo processo, Boolean isMaskUser) {
        if (usuario == null) {
            return null;
        }
        UsuarioPermissaoLocalDTO.UsuarioPermissaoLocalDTOBuilder usuarioPermissaoLocalDTO = UsuarioPermissaoLocalDTO.builder();
        String idMask = isMaskUser != false && usuario.getId().equals(usuario.getCpf()) ? CpfCnpjUtils.getMaskCnpjCpf((String)usuario.getId()) : usuario.getId();
        usuarioPermissaoLocalDTO.loginUsuario(usuario.getId());
        usuarioPermissaoLocalDTO.loginUsuarioMask(idMask);
        usuarioPermissaoLocalDTO.nomeUsuario(usuario.getNome());
        usuarioPermissaoLocalDTO.ativo(usuario.getAtivo());
        usuarioPermissaoLocalDTO.alteraTodosProc(UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Processo)processo));
        return usuarioPermissaoLocalDTO.build();
    }

    private Long processoIdNumero(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        return id.getNumero();
    }

    private TipoProcesso processoIdTipo(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        return id.getTipo();
    }

    private Long processoIdAno(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        return id.getAno();
    }

    private Entidade processoIdEntidade(Processo processo) {
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        return id.getEntidade();
    }

    private List<TramiteDTO> tramiteListToTramiteDTOList(List<Tramite> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TramiteDTO> list1 = new ArrayList<TramiteDTO>(list.size());
        for (Tramite tramite : list) {
            list1.add(new TramiteDTOConverter().to(tramite));
        }
        return list1;
    }

    private List<ProcessoAnexoDTO> processoAnexoListToProcessoAnexoDTOList(List<ProcessoAnexo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoAnexoDTO> list1 = new ArrayList<ProcessoAnexoDTO>(list.size());
        for (ProcessoAnexo processoAnexo : list) {
            list1.add(new ProcessoAnexoDTOConverter().to(processoAnexo));
        }
        return list1;
    }

    private List<ProcessoArquivoDTO> processoArquivoListToProcessoArquivoDTOList(List<ProcessoArquivo> list, Boolean isMaskCpf, Boolean isMaskCNPJ, Boolean isMaskUser, Boolean isOrdemCrescenteAnexo, Boolean isOrdemDecrescenteApenasCampoCalculado) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoArquivoDTO> list1 = new ArrayList<ProcessoArquivoDTO>(list.size());
        for (ProcessoArquivo processoArquivo : list) {
            list1.add(new ProcessoArquivoDTOConverter().to(processoArquivo, isMaskCpf, isMaskCNPJ, isMaskUser));
        }
        if (Boolean.TRUE.equals(isOrdemCrescenteAnexo) || Boolean.TRUE.equals(isOrdemDecrescenteApenasCampoCalculado)) {
            list1.sort(Comparator.comparing(ProcessoArquivoDTO::getOrdem));
        } else {
            list1.sort(Comparator.comparing(ProcessoArquivoDTO::getOrdem).reversed());
        }
        return list1;
    }

    private List<ProcessoInteressadoDTO> processoInteressadoListToProcessoInteressadoDTOList(List<ProcessoInteressado> list, Boolean isMaskCpf, Boolean isMaskCNPJ) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoInteressadoDTO> list1 = new ArrayList<ProcessoInteressadoDTO>(list.size());
        for (ProcessoInteressado processoInteressado : list) {
            list1.add(new ProcessoInteressadoDTOConverter().to(processoInteressado, isMaskCpf, isMaskCNPJ));
        }
        return list1;
    }

    private ProcessoDTO buildProcedimentoOrigem(Processo processo) {
        ProcessoDTO processoDTO = new ProcessoDTO();
        if (StringUtils.isNotBlank((CharSequence)processo.getProcessoReferencia())) {
            ProcessoReferenciaDTO refDTO = ProcessoReferenciaDTOBuilder.buildProcessoReferenciaDTO((Processo)processo);
            if (Objects.isNull(refDTO)) {
                return null;
            }
            processoDTO.setTipo(TipoProcessoSimpleDTO.of((Long)refDTO.getTipo()));
            processoDTO.setAno(refDTO.getAno());
            processoDTO.setNumero(refDTO.getNumero());
            processoDTO.setEntidade(EntidadeDTO.of((Long)refDTO.getEntidade()));
        }
        return processoDTO;
    }

    private List<ProcessoObservadorExternoDTO> buildObservadorExterno(Processo processo) {
        return processo.getObservadoresExternos().stream().map(obs -> new ProcessoObservadorExternoDTOConverter().to(obs)).collect(Collectors.toList());
    }
}

