/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.protocolo.converter.DocumentoDTOConverter;
import br.com.elotech.protocolo.converter.UsuarioSimpleDTOConverter;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.domain.ProcessoArquivoPK;
import br.com.elotech.protocolo.dto.ProcessoArquivoAssinaturaDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.enums.AssinaturaSituacaoEnum;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ProcessoArquivoDTOConverter {
    public ProcessoArquivoDTO to(ProcessoArquivo entity) {
        return this.to(entity, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
    }

    public ProcessoArquivoDTO to(ProcessoArquivo entity, Boolean isMaskCpf, Boolean isMaskCNPJ, Boolean isMaskUser) {
        if (entity == null) {
            return null;
        }
        ProcessoArquivoDTO processoArquivoDTO = new ProcessoArquivoDTO();
        processoArquivoDTO.setSequencia(this.processoArquivoIdSequencia(entity));
        processoArquivoDTO.setNome(entity.getNome());
        processoArquivoDTO.setDescricao(entity.getDescricao());
        processoArquivoDTO.setIdArquivo(entity.getIdArquivo());
        processoArquivoDTO.setUrlS3(entity.getUrlS3());
        processoArquivoDTO.setIdentificador(entity.getIdentificador());
        processoArquivoDTO.setSequenciaTramitacao(entity.getSequenciaTramitacao());
        processoArquivoDTO.setUsuario(entity.getUsuario());
        if (Boolean.TRUE.equals(isMaskUser) && Objects.nonNull(entity.getUsuario()) && entity.getUsuario().equals(entity.getUsuarioCpf())) {
            processoArquivoDTO.setUsuario(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getUsuarioCpf()));
        }
        processoArquivoDTO.setUsuarioNome(entity.getUsuarioNome());
        processoArquivoDTO.setOrdem(entity.getOrdem());
        processoArquivoDTO.setIdAndamento(entity.getIdAndamento());
        processoArquivoDTO.setDataCriacao(entity.getDataCriacao());
        processoArquivoDTO.setAgrupamento(entity.getAgrupamento());
        processoArquivoDTO.setDocumento(new DocumentoDTOConverter().to(entity.getDocumento()));
        processoArquivoDTO.setAnalise(entity.getAnalise());
        processoArquivoDTO.setMotivoRecusa(entity.getMotivoRecusa());
        processoArquivoDTO.setSigiloExterno(entity.getSigiloExterno());
        processoArquivoDTO.setSalvoPeloSistema(entity.getSalvoPeloSistema());
        processoArquivoDTO.setAssinaturas(this.processoArquivoAssinaturaListToProcessoArquivoAssinaturaDTOList(entity.getAssinaturas(), isMaskCpf, isMaskCNPJ, isMaskUser));
        processoArquivoDTO.setQtdAssinaturas(entity.getQtdAssinaturas());
        processoArquivoDTO.setQtdAssinaturasPendentes(entity.getQtdAssinaturasPendentes());
        processoArquivoDTO.setCancelado(entity.getCancelado());
        processoArquivoDTO.setDataCancelamento(entity.getDataCancelamento());
        processoArquivoDTO.setMotivoCancelamento(entity.getMotivoCancelamento());
        processoArquivoDTO.setSituacao(entity.getSituacao());
        processoArquivoDTO.setFilaIntegracaoAssinatura(entity.getFilaIntegracaoAssinatura());
        processoArquivoDTO.setTipoIntegracaoAssinatura(entity.getTipoIntegracaoAssinatura());
        processoArquivoDTO.setIdIntegracaoAssinatura(entity.getIdIntegracaoAssinatura());
        processoArquivoDTO.setPossuiAssinaturaPendente(entity.possuiAssinaturaSituacao(AssinaturaSituacaoEnum.PENDENTE));
        processoArquivoDTO.setPossuiAssinaturaRejeitada(entity.possuiAssinaturaSituacao(AssinaturaSituacaoEnum.REJEITADO));
        String usuarioId = Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(Principal::getName).orElse(null);
        processoArquivoDTO.setPossuiAssinaturaPendenteUsuarioLogado(entity.getPossuiAssinaturaPendenteUsuario(usuarioId));
        processoArquivoDTO.setObrigaPosicionamentoAssinatura(entity.getObrigaPosicionamentoAssinatura());
        return processoArquivoDTO;
    }

    private Long processoArquivoIdSequencia(ProcessoArquivo processoArquivo) {
        if (processoArquivo == null) {
            return null;
        }
        ProcessoArquivoPK id = processoArquivo.getId();
        if (id == null) {
            return null;
        }
        Long sequencia = id.getSequencia();
        if (sequencia == null) {
            return null;
        }
        return sequencia;
    }

    private List<ProcessoArquivoAssinaturaDTO> processoArquivoAssinaturaListToProcessoArquivoAssinaturaDTOList(List<ProcessoArquivoAssinatura> list, Boolean isMaskCpf, Boolean isMaskCNPJ, Boolean isMaskUser) {
        if (list == null) {
            return null;
        }
        ArrayList<ProcessoArquivoAssinaturaDTO> list1 = new ArrayList<ProcessoArquivoAssinaturaDTO>(list.size());
        for (ProcessoArquivoAssinatura processoArquivoAssinatura : list) {
            list1.add(this.processoArquivoAssinaturaToProcessoArquivoAssinaturaDTO(processoArquivoAssinatura, isMaskCpf, isMaskCNPJ, isMaskUser));
        }
        return list1;
    }

    private ProcessoArquivoAssinaturaDTO processoArquivoAssinaturaToProcessoArquivoAssinaturaDTO(ProcessoArquivoAssinatura processoArquivoAssinatura, Boolean isMaskCpf, Boolean isMaskCNPJ, Boolean isMaskUser) {
        if (processoArquivoAssinatura == null) {
            return null;
        }
        ProcessoArquivoAssinaturaDTO processoArquivoAssinaturaDTO = new ProcessoArquivoAssinaturaDTO();
        processoArquivoAssinaturaDTO.setId(processoArquivoAssinatura.getId());
        processoArquivoAssinaturaDTO.setUsuario(new UsuarioSimpleDTOConverter().to(processoArquivoAssinatura.getUsuario(), isMaskUser, isMaskCpf, isMaskCNPJ));
        processoArquivoAssinaturaDTO.setUsuarioSolicitante(new UsuarioSimpleDTOConverter().to(processoArquivoAssinatura.getUsuarioSolicitante(), isMaskUser, isMaskCpf, isMaskCNPJ));
        processoArquivoAssinaturaDTO.setDataCriacao(processoArquivoAssinatura.getDataCriacao());
        processoArquivoAssinaturaDTO.setDataAssinatura(processoArquivoAssinatura.getDataAssinatura());
        processoArquivoAssinaturaDTO.setSituacao(processoArquivoAssinatura.getSituacao());
        processoArquivoAssinaturaDTO.setDataRecusa(processoArquivoAssinatura.getDataRecusa());
        processoArquivoAssinaturaDTO.setMotivoRecusa(processoArquivoAssinatura.getMotivoRecusa());
        return processoArquivoAssinaturaDTO;
    }
}

