/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.protocolo.converter.AssuntoDTOConverter;
import br.com.elotech.protocolo.converter.EntidadeDTOConverter;
import br.com.elotech.protocolo.converter.LocalDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoAndamentoAlteracaoRequerenteDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoArquivoDTOConverter;
import br.com.elotech.protocolo.converter.TipoAndamentoDTOConverter;
import br.com.elotech.protocolo.converter.TipoProcessoSimpleDTOConverter;
import br.com.elotech.protocolo.converter.UsuarioDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.ProcessoAndamentoDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoSimpleDTO;
import java.util.Objects;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProcessoAndamentoDTOConverter {
    public ProcessoAndamentoDTO to(ProcessoAndamento entity, Boolean isMaskUser) {
        if (entity == null) {
            return null;
        }
        ProcessoAndamentoDTO processoAndamentoDTO = new ProcessoAndamentoDTO();
        processoAndamentoDTO.setEntidade(new EntidadeDTOConverter().to(this.processoAndamentoProcessoIdEntidade(entity)));
        processoAndamentoDTO.setTipo(new TipoProcessoSimpleDTOConverter().to(this.processoAndamentoProcessoIdTipo(entity)));
        processoAndamentoDTO.setAno(this.processoAndamentoProcessoIdAno(entity));
        processoAndamentoDTO.setNumero(this.processoAndamentoProcessoIdNumero(entity));
        processoAndamentoDTO.setProcessoIdKey(this.processoAndamentoProcessoIdkey(entity));
        processoAndamentoDTO.setSolicitacaoRequerente(entity.getSolicitacaoRequerente());
        processoAndamentoDTO.setRespostaRequerente(entity.getRespostaRequerente());
        processoAndamentoDTO.setDataHoraResposta(entity.getDataHoraResposta());
        processoAndamentoDTO.setId(entity.getId());
        processoAndamentoDTO.setDataHora(entity.getDataHora());
        processoAndamentoDTO.setDescricao(entity.getDescricao());
        processoAndamentoDTO.setUsuario(entity.getUsuario());
        if (isMaskUser.booleanValue() && entity.getUsuarioId() != null && entity.getUsuarioId().equals(entity.getUsuarioCpf())) {
            processoAndamentoDTO.setUsuario(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getUsuarioCpf()));
        }
        processoAndamentoDTO.setUsuarioNome(entity.getUsuarioNome());
        processoAndamentoDTO.setTramite(entity.getTramite());
        processoAndamentoDTO.setModulo(entity.getModulo());
        processoAndamentoDTO.setDataFinalizacao(entity.getDataFinalizacao());
        processoAndamentoDTO.setDataInicio(entity.getDataInicio());
        processoAndamentoDTO.setDataTermino(entity.getDataTermino());
        processoAndamentoDTO.setTipoAndamento(new TipoAndamentoDTOConverter().to(entity.getTipoAndamento()));
        processoAndamentoDTO.setFinalizado(entity.getFinalizado());
        processoAndamentoDTO.setObservadorExtId(entity.getObservadorExtId());
        processoAndamentoDTO.setDiasSuspensao(entity.getDiasSuspensao());
        processoAndamentoDTO.setNumeroAndamento(entity.getNumeroAndamento());
        processoAndamentoDTO.setAssuntoOld(new AssuntoDTOConverter().to(entity.getAssuntoOld()));
        processoAndamentoDTO.setAssuntoNew(new AssuntoDTOConverter().to(entity.getAssuntoNew()));
        processoAndamentoDTO.setSituacao(entity.getSituacao());
        processoAndamentoDTO.setLocal(new LocalDTOConverter().to(entity.getLocal()));
        processoAndamentoDTO.setUsuarioResponsavel(new UsuarioDTOConverter().to(entity.getUsuarioResponsavel()));
        processoAndamentoDTO.setResposta(entity.getResposta());
        processoAndamentoDTO.setRequerimento(entity.getProcesso().getDigitacao());
        ProcessoAndamentoDTOConverter.adicionarArquivos((ProcessoAndamento)entity, (ProcessoAndamentoDTO)processoAndamentoDTO);
        processoAndamentoDTO.setAlteracaoRequerente(new ProcessoAndamentoAlteracaoRequerenteDTOConverter().to(entity.getAlteracaoRequerente()));
        return processoAndamentoDTO;
    }

    private static void adicionarArquivos(ProcessoAndamento entity, ProcessoAndamentoDTO processoAndamentoDTO) {
        processoAndamentoDTO.getArquivosProcesso().addAll(entity.getProcesso().getArquivos().stream().filter(arquivo -> Objects.nonNull(entity.getId()) && entity.getId().equals(arquivo.getIdAndamento())).map(arquivo -> new ProcessoArquivoDTOConverter().to(arquivo)).collect(Collectors.toList()));
    }

    public ProcessoAndamentoSimpleDTO toSimple(ProcessoAndamento entity, Boolean isMaskUser) {
        if (entity == null) {
            return null;
        }
        ProcessoAndamentoSimpleDTO processoAndamentoDTO = new ProcessoAndamentoSimpleDTO();
        processoAndamentoDTO.setEntidade(new EntidadeDTOConverter().to(this.processoAndamentoProcessoIdEntidade(entity)));
        processoAndamentoDTO.setTipo(new TipoProcessoSimpleDTOConverter().to(this.processoAndamentoProcessoIdTipo(entity)));
        processoAndamentoDTO.setAno(this.processoAndamentoProcessoIdAno(entity));
        processoAndamentoDTO.setNumero(this.processoAndamentoProcessoIdNumero(entity));
        processoAndamentoDTO.setProcessoIdKey(this.processoAndamentoProcessoIdkey(entity));
        processoAndamentoDTO.setSolicitacaoRequerente(entity.getSolicitacaoRequerente());
        processoAndamentoDTO.setRespostaRequerente(entity.getRespostaRequerente());
        processoAndamentoDTO.setDataHoraResposta(entity.getDataHoraResposta());
        processoAndamentoDTO.setId(entity.getId());
        processoAndamentoDTO.setDataHora(entity.getDataHora());
        processoAndamentoDTO.setDescricao(entity.getDescricao());
        processoAndamentoDTO.setUsuario(entity.getUsuario());
        if (isMaskUser.booleanValue() && entity.getUsuarioId() != null && entity.getUsuarioId().equals(entity.getUsuarioCpf())) {
            processoAndamentoDTO.setUsuario(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getUsuarioCpf()));
        }
        processoAndamentoDTO.setUsuarioNome(entity.getUsuarioNome());
        processoAndamentoDTO.setTramite(entity.getTramite());
        processoAndamentoDTO.setModulo(entity.getModulo());
        processoAndamentoDTO.setDataFinalizacao(entity.getDataFinalizacao());
        processoAndamentoDTO.setDataInicio(entity.getDataInicio());
        processoAndamentoDTO.setDataTermino(entity.getDataTermino());
        processoAndamentoDTO.setTipoAndamento(new TipoAndamentoDTOConverter().to(entity.getTipoAndamento()));
        processoAndamentoDTO.setFinalizado(entity.getFinalizado());
        processoAndamentoDTO.setObservadorExtId(entity.getObservadorExtId());
        processoAndamentoDTO.setDiasSuspensao(entity.getDiasSuspensao());
        processoAndamentoDTO.setNumeroAndamento(entity.getNumeroAndamento());
        processoAndamentoDTO.setAssuntoOld(new AssuntoDTOConverter().to(entity.getAssuntoOld()));
        processoAndamentoDTO.setAssuntoNew(new AssuntoDTOConverter().to(entity.getAssuntoNew()));
        processoAndamentoDTO.setSituacao(entity.getSituacao());
        processoAndamentoDTO.setLocal(new LocalDTOConverter().to(entity.getLocal()));
        processoAndamentoDTO.setUsuarioResponsavel(new UsuarioDTOConverter().to(entity.getUsuarioResponsavel()));
        processoAndamentoDTO.setResposta(entity.getResposta());
        processoAndamentoDTO.setRequerimento(entity.getProcesso().getDigitacao());
        processoAndamentoDTO.setBloqueioAnexoExterno(entity.getBloqueioAnexoExterno());
        processoAndamentoDTO.setRequerenteSigiloso(entity.getRequerenteSigiloso());
        processoAndamentoDTO.setAlteracaoRequerente(new ProcessoAndamentoAlteracaoRequerenteDTOConverter().to(entity.getAlteracaoRequerente()));
        return processoAndamentoDTO;
    }

    private Entidade processoAndamentoProcessoIdEntidade(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Entidade entidade = id.getEntidade();
        if (entidade == null) {
            return null;
        }
        return entidade;
    }

    private TipoProcesso processoAndamentoProcessoIdTipo(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        TipoProcesso tipo = id.getTipo();
        if (tipo == null) {
            return null;
        }
        return tipo;
    }

    private Long processoAndamentoProcessoIdAno(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Long ano = id.getAno();
        if (ano == null) {
            return null;
        }
        return ano;
    }

    private Long processoAndamentoProcessoIdNumero(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        Long numero = id.getNumero();
        if (numero == null) {
            return null;
        }
        return numero;
    }

    private String processoAndamentoProcessoIdkey(ProcessoAndamento processoAndamento) {
        if (processoAndamento == null) {
            return null;
        }
        Processo processo = processoAndamento.getProcesso();
        if (processo == null) {
            return null;
        }
        ProcessoPK id = processo.getId();
        if (id == null) {
            return null;
        }
        String key = id.getKey();
        if (key == null) {
            return null;
        }
        return key;
    }
}

