/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.dto.PessoaSimpleDTO;
import java.util.Objects;

public class PessoaSimpleDTOConverter {
    public PessoaSimpleDTO to(Pessoa entity, Boolean isMaskCPF, Boolean isMaskCNPJ) {
        if (Objects.isNull(entity)) {
            return null;
        }
        PessoaSimpleDTO pessoaDTO = new PessoaSimpleDTO();
        pessoaDTO.setId(entity.getId());
        pessoaDTO.setTipoPessoa(entity.getTipoPessoa());
        pessoaDTO.setNome(entity.getNome());
        pessoaDTO.setCnpjCpf(entity.getCnpjCpf());
        if (isMaskCPF.booleanValue() && CpfCnpjUtils.isCpf((String)entity.getCnpjCpf()).booleanValue()) {
            pessoaDTO.setCnpjCpf(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getCnpjCpf()));
        } else if (isMaskCNPJ.booleanValue() && !CpfCnpjUtils.isCpf((String)entity.getCnpjCpf()).booleanValue()) {
            pessoaDTO.setCnpjCpf(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getCnpjCpf()));
        }
        pessoaDTO.setTelefone(this.pessoaContatoTelefone(entity));
        pessoaDTO.setCelular(this.pessoaContatoCelular(entity));
        pessoaDTO.setEmail(this.pessoaContatoEmail(entity));
        pessoaDTO.setCargo(entity.getCargo());
        pessoaDTO.setRg(entity.getRg());
        if (Objects.nonNull(entity.getEnderecoPrincipal())) {
            pessoaDTO.setEnderecoFormatado(entity.getEnderecoPrincipal().getEnderecoFormatado());
        }
        pessoaDTO.setAtivo(entity.getAtivo());
        pessoaDTO.setIdUnico(entity.getIdUnico());
        pessoaDTO.setDataNascimento(entity.getDataNascimento());
        pessoaDTO.setDadosSigilosos(entity.getDadosSigilosos());
        return pessoaDTO;
    }

    private String pessoaContatoCelular(Pessoa pessoa) {
        if (Objects.isNull(pessoa) || Objects.isNull(pessoa.getContato())) {
            return null;
        }
        return pessoa.getContato().getCelular();
    }

    private String pessoaContatoTelefone(Pessoa pessoa) {
        if (Objects.isNull(pessoa) || Objects.isNull(pessoa.getContato())) {
            return null;
        }
        return pessoa.getContato().getTelefone();
    }

    private String pessoaContatoEmail(Pessoa pessoa) {
        if (Objects.isNull(pessoa) || Objects.isNull(pessoa.getContato())) {
            return null;
        }
        return pessoa.getContato().getEmail();
    }
}

