/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.utils.CpfCnpjUtils;
import br.com.elotech.protocolo.converter.EnderecoPessoaDTOConverter;
import br.com.elotech.protocolo.domain.Contato;
import br.com.elotech.protocolo.domain.EnderecoPessoa;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.dto.EnderecoPessoaDTO;
import br.com.elotech.protocolo.dto.PessoaDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PessoaDTOConverter {
    public PessoaDTO to(Pessoa entity, Boolean isMaskCPF, Boolean isMaskCNPJ) {
        if (Objects.isNull(entity)) {
            return null;
        }
        EnderecoPessoaDTOConverter enderecoPessoaDTOConverter = new EnderecoPessoaDTOConverter();
        PessoaDTO pessoaDTO = new PessoaDTO();
        pessoaDTO.setId(entity.getId());
        pessoaDTO.setTipoPessoa(entity.getTipoPessoa());
        pessoaDTO.setNome(entity.getNome());
        pessoaDTO.setCnpjCpf(entity.getCnpjCpf());
        if (isMaskCPF.booleanValue() && CpfCnpjUtils.isCpf((String)entity.getCnpjCpf()).booleanValue()) {
            pessoaDTO.setCnpjCpf(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getCnpjCpf()));
        } else if (isMaskCNPJ.booleanValue() && !CpfCnpjUtils.isCpf((String)entity.getCnpjCpf()).booleanValue()) {
            pessoaDTO.setCnpjCpf(CpfCnpjUtils.getMaskCnpjCpf((String)entity.getCnpjCpf()));
        }
        pessoaDTO.setTelefone(this.pessoaContatoTelefone(entity));
        pessoaDTO.setCelular(this.pessoaContatoCelular(entity));
        pessoaDTO.setEmail(this.pessoaContatoEmail(entity));
        pessoaDTO.setCargo(entity.getCargo());
        pessoaDTO.setRg(entity.getRg());
        pessoaDTO.setEnderecoPrincipal(enderecoPessoaDTOConverter.to(entity.getEnderecoPrincipal()));
        pessoaDTO.setEnderecos(this.enderecoPessoaListToEnderecoPessoaDTOList(entity.getEnderecos(), enderecoPessoaDTOConverter));
        pessoaDTO.setAtivo(entity.getAtivo());
        pessoaDTO.setIdUnico(entity.getIdUnico());
        pessoaDTO.setDataNascimento(entity.getDataNascimento());
        pessoaDTO.setDadosSigilosos(entity.getDadosSigilosos());
        return pessoaDTO;
    }

    public Pessoa from(PessoaDTO dto) {
        Contato contato = new Contato();
        contato.setEmail(dto.getEmail());
        Pessoa pessoa = new Pessoa();
        pessoa.setId(dto.getId());
        pessoa.setCnpjCpf(dto.getCnpjCpf());
        pessoa.setNome(dto.getNome());
        pessoa.setContato(contato);
        return pessoa;
    }

    private List<EnderecoPessoaDTO> enderecoPessoaListToEnderecoPessoaDTOList(List<EnderecoPessoa> list, EnderecoPessoaDTOConverter enderecoPessoaDTOConverter) {
        if (list == null) {
            return null;
        }
        ArrayList<EnderecoPessoaDTO> list1 = new ArrayList<EnderecoPessoaDTO>(list.size());
        for (EnderecoPessoa enderecoPessoa : list) {
            list1.add(enderecoPessoaDTOConverter.to(enderecoPessoa));
        }
        return list1;
    }

    private String pessoaContatoCelular(Pessoa pessoa) {
        if (pessoa == null) {
            return null;
        }
        Contato contato = pessoa.getContato();
        if (contato == null) {
            return null;
        }
        String celular = contato.getCelular();
        if (celular == null) {
            return null;
        }
        return celular;
    }

    private String pessoaContatoTelefone(Pessoa pessoa) {
        if (pessoa == null) {
            return null;
        }
        Contato contato = pessoa.getContato();
        if (contato == null) {
            return null;
        }
        String telefone = contato.getTelefone();
        if (telefone == null) {
            return null;
        }
        return telefone;
    }

    private String pessoaContatoEmail(Pessoa pessoa) {
        if (pessoa == null) {
            return null;
        }
        Contato contato = pessoa.getContato();
        if (contato == null) {
            return null;
        }
        String email = contato.getEmail();
        if (email == null) {
            return null;
        }
        return email;
    }
}

