/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class HashMapConverter {
    private HashMapConverter() {
    }

    public static String toString(HashMap<String, Object> hashMap) {
        if (Objects.isNull(hashMap)) {
            return "";
        }
        return hashMap.keySet().stream().map(key -> key + "=" + String.valueOf(hashMap.get(key))).collect(Collectors.joining(", ", "{", "}"));
    }

    public static HashMap<String, Object> toHashMap(String hashMapString) {
        if (Objects.isNull(hashMapString) || hashMapString.isEmpty() || hashMapString.isBlank()) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = Arrays.stream(Optional.ofNullable(hashMapString).orElse("").replace("{", "").replace("}", "").split(",")).map(entry -> entry.split("=")).collect(Collectors.toMap(entry -> entry[0].trim(), entry -> entry[1].trim()));
        return (HashMap)map;
    }
}

