/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.converter;

import br.com.elotech.adm.converter.DTOConverter;
import br.com.elotech.protocolo.converter.AssuntoArquivoDTOConverter;
import br.com.elotech.protocolo.converter.AssuntoDocumentoDTOConverter;
import br.com.elotech.protocolo.converter.RoteiroDTOConverter;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.AssuntoArquivo;
import br.com.elotech.protocolo.domain.AssuntoDocumento;
import br.com.elotech.protocolo.dto.AssuntoArquivoDTO;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.AssuntoDocumentoDTO;
import java.util.ArrayList;
import java.util.List;

public class AssuntoDTOConverter
implements DTOConverter<Assunto, AssuntoDTO> {
    public Assunto from(AssuntoDTO dto) {
        Assunto assunto = Assunto.of((Long)dto.getId());
        assunto.setDescricao(dto.getDescricao());
        return assunto;
    }

    public AssuntoDTO to(Assunto entity) {
        if (entity == null) {
            return null;
        }
        AssuntoDTO.AssuntoDTOBuilder assuntoDTO = AssuntoDTO.builder();
        assuntoDTO.id(entity.getId());
        assuntoDTO.descricao(entity.getDescricao());
        assuntoDTO.possuiTaxas(entity.getPossuiTaxas());
        assuntoDTO.controlaTramitacao(entity.getControlaTramitacao());
        assuntoDTO.assuntoInterno(entity.getAssuntoInterno());
        assuntoDTO.ativo(entity.getAtivo());
        assuntoDTO.possuiParticipantesExtrasExterno(entity.getPossuiParticipantesExtrasExterno());
        assuntoDTO.mensagem(entity.getMensagem());
        assuntoDTO.complemento(entity.getComplemento());
        assuntoDTO.assuntoDocumento(this.assuntoDocumentoListToAssuntoDocumentoDTOList(entity.getAssuntoDocumento()));
        assuntoDTO.roteiro(new RoteiroDTOConverter().to(entity.getRoteiro()));
        assuntoDTO.prazoArquivamento(entity.getPrazoArquivamento());
        assuntoDTO.destinacaoFinal(entity.getDestinacaoFinal());
        assuntoDTO.obrigaDadosImovel(entity.getObrigaDadosImovel());
        assuntoDTO.ouvidoria(entity.getOuvidoria());
        assuntoDTO.termoAceite(entity.getTermoAceite());
        assuntoDTO.notaExplicativa(entity.getNotaExplicativa());
        assuntoDTO.termoResponsabilidade(entity.getTermoResponsabilidade());
        assuntoDTO.obrigaArquivosAssuntoInterno(entity.getObrigaArquivosAssuntoInterno());
        assuntoDTO.sigiloso(entity.getSigiloso());
        assuntoDTO.obrigaArquivosAssuntoExterno(entity.getObrigaArquivosAssuntoExterno());
        assuntoDTO.carregaRequerimentoExterno(entity.getCarregaRequerimentoExterno());
        assuntoDTO.exibeDadosImovel(entity.getExibeDadosImovel());
        assuntoDTO.requerimento(entity.getRequerimento());
        assuntoDTO.observacao(entity.getObservacao());
        assuntoDTO.arquivos(this.assuntoArquivoListToAssuntoArquivoDTOList(entity.getArquivos()));
        assuntoDTO.assuntoPai(this.to(entity.getAssuntoPai()));
        assuntoDTO.obrigaEnderecoComplementar(entity.getObrigaEnderecoComplementar());
        assuntoDTO.denunciado(entity.getDenunciado());
        assuntoDTO.obrigaComplementoAssunto(entity.getObrigaComplementoAssunto());
        assuntoDTO.esic(entity.getEsic());
        return assuntoDTO.build();
    }

    private List<AssuntoDocumentoDTO> assuntoDocumentoListToAssuntoDocumentoDTOList(List<AssuntoDocumento> list) {
        if (list == null) {
            return null;
        }
        AssuntoDocumentoDTOConverter assuntoDocumentoDTOConverter = new AssuntoDocumentoDTOConverter();
        ArrayList<AssuntoDocumentoDTO> list1 = new ArrayList<AssuntoDocumentoDTO>(list.size());
        for (AssuntoDocumento assuntoDocumento : list) {
            list1.add(assuntoDocumentoDTOConverter.to(assuntoDocumento));
        }
        return list1;
    }

    private List<AssuntoArquivoDTO> assuntoArquivoListToAssuntoArquivoDTOList(List<AssuntoArquivo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AssuntoArquivoDTO> list1 = new ArrayList<AssuntoArquivoDTO>(list.size());
        for (AssuntoArquivo assuntoArquivo : list) {
            list1.add(new AssuntoArquivoDTOConverter().to(assuntoArquivo));
        }
        return list1;
    }
}

