/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config.audit;

import br.com.elotech.protocolo.domain.PersistentAuditEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class AuditEventConverter {
    public List<AuditEvent> convertToAuditEvent(Iterable<PersistentAuditEvent> persistentAuditEvents) {
        if (persistentAuditEvents == null) {
            return Collections.emptyList();
        }
        ArrayList<AuditEvent> auditEvents = new ArrayList<AuditEvent>();
        for (PersistentAuditEvent persistentAuditEvent : persistentAuditEvents) {
            auditEvents.add(this.convertToAuditEvent(persistentAuditEvent));
        }
        return auditEvents;
    }

    public AuditEvent convertToAuditEvent(PersistentAuditEvent persistentAuditEvent) {
        return new AuditEvent(persistentAuditEvent.getPrincipal(), persistentAuditEvent.getAuditEventType(), this.convertDataToObjects(persistentAuditEvent.getData()));
    }

    public Map<String, Object> convertDataToObjects(Map<String, String> data) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                results.put(entry.getKey(), entry.getValue());
            }
        }
        return results;
    }

    public Map<String, String> convertDataToStrings(Map<String, Object> data) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                Object object = entry.getValue();
                if (object instanceof WebAuthenticationDetails) {
                    WebAuthenticationDetails authenticationDetails = (WebAuthenticationDetails)object;
                    results.put("remoteAddress", authenticationDetails.getRemoteAddress());
                    results.put("sessionId", authenticationDetails.getSessionId());
                    continue;
                }
                if (object == null) {
                    results.put(entry.getKey(), "null");
                    continue;
                }
                results.put(entry.getKey(), object.toString());
            }
        }
        return results;
    }
}

