/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.dto.ResponseErrorDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class ResponseErrorHandlerConfig
implements ResponseErrorHandler {
    private final ObjectMapper mapper;

    public ResponseErrorHandlerConfig(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return response.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR || response.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        if (response.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR) {
            this.handleClientError(response);
        }
        if (response.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR) {
            this.handleServerError(response);
        }
    }

    private void handleServerError(ClientHttpResponse response) throws IOException {
        String json;
        try (InputStream is = response.getBody();){
            json = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        ResponseErrorDTO responseError = (ResponseErrorDTO)this.mapper.readValue(json, ResponseErrorDTO.class);
        if (responseError.getMessage() != null && responseError.getMessage().contains("cidade")) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, responseError.getMessage().concat(", \u00c9 necess\u00e1rio alterar o endere\u00e7o do contribuinte no sistema tribut\u00e1rio."));
        }
        if (response.getStatusCode() == HttpStatus.INTERNAL_SERVER_ERROR) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, responseError.getMessage());
        }
    }

    private void handleClientError(ClientHttpResponse response) throws IOException {
        String json;
        try (InputStream is = response.getBody();){
            json = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        ResponseErrorDTO responseError = (ResponseErrorDTO)this.mapper.readValue(json, ResponseErrorDTO.class);
        if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
            throw new RestException(HttpStatus.NOT_FOUND, responseError.getMessage());
        }
        if (response.getStatusCode() == HttpStatus.BAD_REQUEST) {
            throw new RestException(HttpStatus.BAD_REQUEST, responseError.getMessage());
        }
    }
}

