/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.core.config.AllProfilesCondition;
import br.com.elotech.core.security.SecurityConfigurerCustomize;
import br.com.elotech.protocolo.config.PessoaClientUnico;
import br.com.elotech.protocolo.security.AuthenticationClientUnico;
import br.com.elotech.protocolo.security.ProtocoloPublicEndpointsHelper;
import br.com.elotech.unico.client.AuthenticationClientUnicoFeign;
import br.com.elotech.unico.client.PessoaFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Configuration
@ComponentScan(basePackages={"br.com.elotech.core.security"}, basePackageClasses={AllProfilesCondition.class})
@Profile(value={"cloud", "onpremise", "unico"})
public class ProtocoloUnicoConfiguration
implements SecurityConfigurerCustomize {
    @Bean
    public PessoaClientUnico pessoaClientUnico(PessoaFeignClient pessoaFeignClient) {
        return new PessoaClientUnico(pessoaFeignClient);
    }

    @Bean
    public AuthenticationClientUnico authenticationClientUnico(AuthenticationClientUnicoFeign authenticationClientUnico) {
        return new AuthenticationClientUnico(authenticationClientUnico);
    }

    public void configure(HttpSecurity http) {
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry reqs = http.authorizeRequests();
        for (String endpoint : ProtocoloPublicEndpointsHelper.PUBLIC_ENDPOINTS) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)reqs.antMatchers(new String[]{endpoint})).permitAll();
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)reqs.anyRequest()).authenticated();
    }
}

