/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.adm.utils.SqlUtils;
import br.com.elotech.protocolo.interceptor.ProtocoloHibernatePrePersist;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"elotech.protocolo.databaseconverter.enabled"}, havingValue="true", matchIfMissing=true)
@Component
public class ProtocoloHibernateIntegratorDatabaseEncodingConverter
implements Integrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocoloHibernateIntegratorDatabaseEncodingConverter.class);
    public static boolean didIntegrate;
    private static final String PROPERTY_FORCE = "elotech.protocolo.databaseconverter.force";
    private final ProtocoloHibernatePrePersist protocoloHibernatePrePersist;
    private final DataSource dataSource;
    @Value(value="${elotech.protocolo.databaseconverter.force:false}")
    private boolean forceConversor;

    @Autowired
    public ProtocoloHibernateIntegratorDatabaseEncodingConverter(ProtocoloHibernatePrePersist protocoloHibernatePrePersist, DataSource dataSource) {
        this.protocoloHibernatePrePersist = protocoloHibernatePrePersist;
        this.dataSource = dataSource;
    }

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)sessionFactory.getServiceRegistry().getService(EventListenerRegistry.class);
        if (!this.shouldIntegrate()) {
            log.info("N\u00e3o vai integrar");
            return;
        }
        log.info("Integrando");
        didIntegrate = true;
        eventListenerRegistry.appendListeners(EventType.PERSIST, (Object[])new PersistEventListener[]{this.protocoloHibernatePrePersist});
        eventListenerRegistry.appendListeners(EventType.FLUSH_ENTITY, (Object[])new FlushEntityEventListener[]{this.protocoloHibernatePrePersist});
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (didIntegrate) {
            log.info("Desintegrando conversor");
        } else {
            log.info("Conversor n\u00e3o integrado, ent\u00e3o n\u00e3o vai desintegrar");
        }
    }

    private boolean shouldIntegrate() {
        String encoding = this.getDatabaseEncoding();
        log.info("Encoding do banco de dados: {}", (Object)encoding);
        boolean useEncoding = Objects.isNull(encoding) || encoding.contains("1252");
        log.info("Uso ativo pelo encoding: {}", (Object)(useEncoding ? "ATIVADO" : "DESATIVADO"));
        log.info("Uso for\u00e7ado ({}): {}", (Object)PROPERTY_FORCE, (Object)this.forceConversor);
        return Boolean.TRUE.equals(this.forceConversor) || useEncoding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDatabaseEncoding() {
        try (Connection connection = this.dataSource.getConnection();){
            if (Objects.isNull(connection)) {
                log.info("N\u00e3o foi poss\u00edvel obter a conex\u00e3o para identificar o encoding");
                String string = null;
                return string;
            }
            try (Statement statement = connection.createStatement();){
                String sql;
                String platform = connection.getMetaData().getDatabaseProductName();
                if (SqlUtils.isPostgres((String)platform)) {
                    sql = "SELECT pg_encoding_to_char(encoding) FROM pg_database WHERE datname = current_database()";
                } else if (SqlUtils.isOracle((String)platform)) {
                    sql = "SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'";
                } else {
                    if (SqlUtils.isH2((String)platform)) {
                        String string = "WIN1252";
                        return string;
                    }
                    log.warn("N\u00e3o foi poss\u00edvel identificar o encoding do banco de dados ou \u00e9 H2: {}", (Object)platform);
                    String string = null;
                    return string;
                }
                try (ResultSet resultSet = statement.executeQuery(sql);){
                    if (!resultSet.next()) return null;
                    String string = resultSet.getString(1);
                    return string;
                }
            }
        }
        catch (SQLException e) {
            log.error("Erro ao obter o encoding do banco de dados", (Throwable)e);
        }
        return null;
    }
}

