/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.protocolo.config.ProtocoloHibernateIntegratorDatabaseEncodingConverter;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"!cloud"})
@ConditionalOnProperty(value={"elotech.protocolo.databaseconverter.enabled"}, havingValue="true", matchIfMissing=true)
public class ProtocoloHibernateConfiguration
implements HibernatePropertiesCustomizer {
    private final ProtocoloHibernateIntegratorDatabaseEncodingConverter hibernateIntegratorConfiguration;

    @Autowired
    public ProtocoloHibernateConfiguration(ProtocoloHibernateIntegratorDatabaseEncodingConverter hibernateIntegratorConfiguration) {
        this.hibernateIntegratorConfiguration = hibernateIntegratorConfiguration;
    }

    public void customize(Map<String, Object> hibernateProperties) {
        hibernateProperties.put("hibernate.integrator_provider", () -> List.of(this.hibernateIntegratorConfiguration));
    }
}

