/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.ErrorMessage;
import br.com.elotech.core.exception.GlobalControllerExceptionHandler;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Import(value={GlobalControllerExceptionHandler.class})
@Configuration
public class ProtocoloGlobalExceptionHandlerConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocoloGlobalExceptionHandlerConfiguration.class);
    private final String applicationName;

    public ProtocoloGlobalExceptionHandlerConfiguration(@Value(value="${spring.application.name:protocolo-api}") String applicationName) {
        this.applicationName = applicationName;
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    ResponseEntity<ErrorMessage> handleUndeclaredThrowableException(HttpServletRequest request, UndeclaredThrowableException ex) {
        log.warn("Undeclared Throwable Exception message: {}", (Object)StringUtils.stripToEmpty((String)ex.getMessage()), (Object)ex);
        return this.createErrorMessage((Throwable)Objects.requireNonNullElse(ex.getUndeclaredThrowable(), ex), request.getRequestURI());
    }

    private ResponseEntity<ErrorMessage> createErrorMessage(Throwable ex, String requestURI) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        Exception handledException = ex instanceof Exception ? (Exception)ex : new Exception(ex.getMessage(), ex);
        ErrorMessage errorMessage = new ErrorMessage(handledException, status, requestURI);
        if (handledException instanceof EloValidationException) {
            EloValidationException eloValidationException = (EloValidationException)handledException;
            errorMessage.setViolations(eloValidationException.getViolations());
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).header("X-Elo-Exception", new String[]{"true"})).header("X-Elo-AppName-Exception", new String[]{this.applicationName})).body((Object)errorMessage);
    }
}

