/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.unico.client.PessoaFeignClient;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.PessoaExistsDTO;
import br.com.elotech.unico.exception.UnicoClientException;
import feign.FeignException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class PessoaClientUnico {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PessoaClientUnico.class);
    private final PessoaFeignClient pessoaFeignClient;

    public PessoaClientUnico(PessoaFeignClient pessoaFeignClient) {
        this.pessoaFeignClient = pessoaFeignClient;
    }

    public PessoaDTO savePessoa(PessoaDTO pessoaDTO) {
        try {
            return this.pessoaFeignClient.savePessoa(pessoaDTO);
        }
        catch (FeignException ex) {
            log.error("Erro inesperado ao salvar a pessoa no \u00fanico. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel inserir a nova pessoa no \u00fanico", (Throwable)ex);
        }
    }

    public PessoaDTO patchPessoa(Long idPessoa, List<JsonUpdatePartial> updates) {
        try {
            ResponseEntity patch = this.pessoaFeignClient.patch(updates, idPessoa);
            return (PessoaDTO)patch.getBody();
        }
        catch (FeignException ex) {
            log.error("Erro inesperado ao alterar a pessoa no \u00fanico. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel alterar a pessoa do \u00fanico", (Throwable)ex);
        }
    }

    public PessoaDTO getPessoaById(Long idPessoa) {
        try {
            return this.pessoaFeignClient.findPessoaById(null, idPessoa);
        }
        catch (FeignException ex) {
            log.error("Erro inesperado ao carregar a pessoa no \u00fanico. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel carregar a pessoa do \u00fanico", (Throwable)ex);
        }
    }

    public PessoaDTO ativaProtocolo(PessoaDTO pessoa) {
        try {
            if (!BooleanUtils.toBoolean((Boolean)pessoa.getProtocolo())) {
                return (PessoaDTO)this.pessoaFeignClient.ativaProtocolo(pessoa.getId(), null).getBody();
            }
            return pessoa;
        }
        catch (FeignException ex) {
            log.error("Erro inesperado ao ativar pessoa como protocolo. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel ativar a pessoa no m\u00f3dulo de protocolo", (Throwable)ex);
        }
    }

    public PessoaDTO ativaProtocolo(Long pessoaId) {
        PessoaDTO pessoaDTO = new PessoaDTO();
        pessoaDTO.setProtocolo(Boolean.valueOf(false));
        pessoaDTO.setId(pessoaId);
        return this.ativaProtocolo(pessoaDTO);
    }

    public void ativaContribuinte(PessoaDTO pessoa) {
        try {
            if (!BooleanUtils.toBoolean((Boolean)pessoa.getContribuinte())) {
                this.pessoaFeignClient.ativaContribuinte(pessoa.getId(), null);
            }
        }
        catch (FeignException ex) {
            log.error("Erro inesperado ao ativar pessoa como contribuinte. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel ativar a pessoa no m\u00f3dulo aise tributos", (Throwable)ex);
        }
    }

    public EloPage<PessoaExistsDTO> exists(String cpfCnpj) {
        try {
            return this.pessoaFeignClient.exists(cpfCnpj);
        }
        catch (FeignException ex) {
            log.error("Erro inesperado ao ativar pessoa como contribuinte. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel ativar a pessoa no m\u00f3dulo aise tributos", (Throwable)ex);
        }
    }
}

