/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.multitenant.client.TenantClient;
import br.com.elotech.multitenant.config.MultiTenantClientConfiguration;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.outbox.EnableOutboxConsumerDataIntegration;
import br.com.elotech.outbox.EnableOutboxProducerDataIntegration;
import br.com.elotech.outbox.hook.OutBoxBeforeProcessHook;
import br.com.elotech.outbox.hook.TenantBeforeProcessHook;
import br.com.elotech.outbox.publisher.PublishKey;
import br.com.elotech.outbox.publisher.RecordEntityClass;
import br.com.elotech.outbox.publisher.RecordSaver;
import br.com.elotech.protocolo.domain.OutboxEntity;
import br.com.elotech.protocolo.repository.OutboxRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableOutboxConsumerDataIntegration
@EnableOutboxProducerDataIntegration
@AutoConfigureAfter(value={MultiTenantClientConfiguration.class})
public class OutboxDataIntegrationConfiguration {
    public static final String TOPIC_EXCHANGE_PROCESSO = "OXY_PROTOCOLO_PROCESSO";
    public static final String TOPIC_EXCHANGE_PROCESSO_ASSINATURA = "OXY_PROTOCOLO_ASSINATURA";
    public static final String OXY_PROTOCOLO_PROCESSO_ERROR_QUEUE = "OXY_PROTOCOLO_PROCESSO_ERROR_QUEUE";
    @Value(value="${amqp.default.key}")
    private String amqpDefaultKey;

    @Bean
    public RecordSaver recordSaver(OutboxRepository outboxRepository) {
        return outboxRecord -> outboxRepository.save((Object)((OutboxEntity)outboxRecord));
    }

    @Bean
    @ConditionalOnProperty(name={"multitenant.enabled"}, havingValue="true")
    public OutBoxBeforeProcessHook tenantBeforeProcess(TenantClient tenantClient) {
        return new TenantBeforeProcessHook(tenantClient);
    }

    @Bean
    public RecordEntityClass recordEntityClass() {
        return OutboxEntity::new;
    }

    @Bean
    public PublishKey publishKey() {
        return () -> TenantContextHolder.getTenantId().orElse(this.amqpDefaultKey);
    }
}

