/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.multitenant.domain.Tenant;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.multitenant.hook.HookException;
import br.com.elotech.multitenant.hook.TenantAfterCreateDataSource;
import br.com.elotech.outbox.publisher.SchedulerPublisher;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutBoxRegisterScheduleTenant
implements TenantAfterCreateDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OutBoxRegisterScheduleTenant.class);
    private final SchedulerPublisher schedulerPublisher;

    public OutBoxRegisterScheduleTenant(SchedulerPublisher schedulerPublisher) {
        this.schedulerPublisher = schedulerPublisher;
    }

    public DataSource process(DataSource dataSource) throws HookException {
        if (!TenantContextHolder.hasTenant()) {
            log.info("Nenhum tenant encontrado. Ignorando registro do scheduler OutBox.");
            return dataSource;
        }
        Tenant tenant = TenantContextHolder.getTenant();
        log.info("Registrando scheduler OutBox para o tenant: {}", (Object)tenant);
        this.schedulerPublisher.registerPolling(() -> {
            log.debug("Init schedule");
            TenantContextHolder.setTenant((Tenant)tenant);
        });
        return dataSource;
    }
}

