/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.keycloakmultirealm.resolver.KeycloakResolver;
import br.com.elotech.keycloakmultirealm.resolver.TenantKeycloak;
import br.com.elotech.multitenant.domain.Tenant;
import br.com.elotech.protocolo.interceptor.ConsoleRequestInterceptorOnPremise;
import java.io.IOException;
import org.keycloak.admin.client.Keycloak;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ClassPathResource;

@Configuration
@Profile(value={"standalone", "onpremise"})
public class ConseoleRestTemplateCustomizerConfiguration {
    private KeycloakResolver keycloakResolver() throws IOException {
        ClassPathResource configFile = new ClassPathResource("keycloak-prod.json");
        return new TenantKeycloak(configFile.getInputStream().readAllBytes());
    }

    private Keycloak keycloakConsoleClient(KeycloakResolver keycloakResolver) {
        return keycloakResolver.getKeycloak(Tenant.of((String)"OxyElotech"));
    }

    @Bean
    public ConsoleRequestInterceptorOnPremise consoleRequestInterceptor() throws IOException {
        return new ConsoleRequestInterceptorOnPremise(this.keycloakConsoleClient(this.keycloakResolver()));
    }

    @Bean
    public BeanPostProcessor consoleClientInterceptorInjector(ConsoleRequestInterceptorOnPremise interceptor) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

