/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCaching
public class CacheConfiguration {
    public static final String CACHE_DASHBOARD = "CACHE_DASHBOARD";

    @Bean
    @Primary
    public CacheManager cacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(List.of(new ConcurrentMapCache("console_client_cache_tenant_modulo"), new ConcurrentMapCache("console_client_cache_tenant_modulo_usuario")));
        return cacheManager;
    }

    @Bean
    public CaffeineCacheManager caffeineCacheManager(@Value(value="${elotech.dashboard.cache-expire-minutes:20}") int ttlMinutes) {
        Caffeine expireAfterWrite = Caffeine.newBuilder().expireAfterWrite((long)ttlMinutes, TimeUnit.MINUTES);
        CaffeineCacheManager cacheManagerCaffeine = new CaffeineCacheManager(new String[]{CACHE_DASHBOARD});
        cacheManagerCaffeine.setCaffeine(expireAfterWrite);
        return cacheManagerCaffeine;
    }
}

