/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.config;

import br.com.elotech.protocolo.aop.encoding.HandleStringEncodingAspect;
import br.com.elotech.protocolo.aop.logging.LoggingAspect;
import br.com.elotech.protocolo.aop.repository.EntidadeHibernateFilterAspect;
import javax.persistence.EntityManagerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Profile;

@Configuration
@EnableAspectJAutoProxy
public class AspectConfiguration {
    @Bean
    @Profile(value={"dev"})
    public LoggingAspect loggingAspect() {
        return new LoggingAspect();
    }

    @Bean
    public EntidadeHibernateFilterAspect entidadeHibernateFilterAspect(EntityManagerFactory emf) {
        return new EntidadeHibernateFilterAspect(emf);
    }

    @Bean
    @Profile(value={"!cloud"})
    @ConditionalOnProperty(value={"elotech.protocolo.databaseconverter.enabled"}, havingValue="true", matchIfMissing=true)
    public HandleStringEncodingAspect handleStringEncodingAspect() {
        return new HandleStringEncodingAspect();
    }
}

