/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.aop.repository;

import br.com.elotech.adm.utils.HibernateFilterAspectUtils;
import br.com.elotech.core.aop.AopRepositoryUtils;
import br.com.elotech.core.web.request.ContextHolder;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManagerFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.hibernate.Filter;
import org.hibernate.annotations.FilterDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class EntidadeHibernateFilterAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntidadeHibernateFilterAspect.class);
    private final EntityManagerFactory emf;

    public EntidadeHibernateFilterAspect(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Pointcut(value="execution(public * br.com.elotech.protocolo.repository..*(..))")
    public void entidadeFilterPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Around(value="entidadeFilterPointcut()")
    public Object repositoryAround(ProceedingJoinPoint joinPoint) {
        Object object;
        Optional domainRepository = AopRepositoryUtils.getDomainRepository((Object)joinPoint.getThis());
        Optional filterDefinition = AopRepositoryUtils.getFilterDef((Optional)domainRepository);
        if (!filterDefinition.isPresent() || !domainRepository.isPresent()) return joinPoint.proceed();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Applying filter {} for repository {} method {}", new Object[]{((FilterDef)filterDefinition.get()).name(), ((Class)domainRepository.get()).getName(), joinPoint.getSignature().getName()});
            }
            this.enableFilter((FilterDef)filterDefinition.get());
            object = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            HibernateFilterAspectUtils.disableFilter((EntityManagerFactory)this.emf, (FilterDef)((FilterDef)filterDefinition.get()));
            throw throwable;
        }
        HibernateFilterAspectUtils.disableFilter((EntityManagerFactory)this.emf, (FilterDef)((FilterDef)filterDefinition.get()));
        return object;
    }

    private void enableFilter(FilterDef filterDef) {
        Integer idEntidade = ContextHolder.getHeaderValueEntidade();
        if (idEntidade <= 0) {
            return;
        }
        Filter filter = HibernateFilterAspectUtils.enableFilter((EntityManagerFactory)this.emf, (FilterDef)filterDef);
        if (Objects.isNull(filter)) {
            return;
        }
        Preconditions.checkArgument((filterDef.parameters().length == 1 ? 1 : 0) != 0, (Object)String.format("Par\u00e2metro n\u00e3o definido pra o filtro: %s.", filterDef.name()));
        filter.setParameter(filterDef.parameters()[0].name(), (Object)idEntidade);
    }
}

