/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.aop.logging;

import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class LoggingAspect {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Environment env;

    @Pointcut(value="execution(public * br.com.elotech.protocolo.repository..*(..)) || within(br.com.elotech.protocolo.service..*) || within(br.com.elotech.protocolo.web.rest..*)")
    public void loggingPointcut() {
    }

    @AfterThrowing(pointcut="loggingPointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        if (this.env.acceptsProfiles(new String[]{"dev"})) {
            this.log.error("Exception in {}.{}() with cause = {} and exception {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), e.getCause(), e});
        } else {
            this.log.error("Exception in {}.{}() with cause = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), e.getCause()});
        }
    }

    @Around(value="loggingPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Enter: {}.{}() with argument[s] = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), Arrays.toString(joinPoint.getArgs())});
        }
        try {
            Object result = joinPoint.proceed();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Exit: {}.{}() with result = {}", new Object[]{joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName(), result});
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            this.log.error("Illegal argument: {} in {}.{}()", new Object[]{Arrays.toString(joinPoint.getArgs()), joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName()});
            throw e;
        }
    }
}

