/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.aop.encoding;

import br.com.elotech.adm.utils.CharsetConverterUtils;
import br.com.elotech.protocolo.config.ProtocoloHibernateIntegratorDatabaseEncodingConverter;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;

@Aspect
public class HandleStringEncodingAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HandleStringEncodingAspect.class);

    public HandleStringEncodingAspect() {
        log.info("Criando HandleStringEncodingAspect");
    }

    @Pointcut(value="execution(public * br.com.elotech.protocolo.repository..*(..))")
    public void handleStringEncodingAspect() {
    }

    @Around(value="handleStringEncodingAspect()")
    public Object repositoryAround(ProceedingJoinPoint joinPoint) throws Throwable {
        boolean shouldUseArgs = false;
        Object[] args = null;
        if (ProtocoloHibernateIntegratorDatabaseEncodingConverter.didIntegrate && joinPoint instanceof MethodInvocationProceedingJoinPoint) {
            try {
                MethodInvocationProceedingJoinPoint methodJoinPoint = (MethodInvocationProceedingJoinPoint)joinPoint;
                log.debug("Verificando encoding da chamada {}", (Object)methodJoinPoint.getSignature().toLongString());
                args = joinPoint.getArgs();
                CharsetConverterUtils.handleArray((Object[])args, (String)methodJoinPoint.getSignature().toShortString());
                shouldUseArgs = true;
            }
            catch (Exception e) {
                log.warn("Falha ao processar handler de Charset", (Throwable)e);
            }
        }
        return shouldUseArgs ? joinPoint.proceed(args) : joinPoint.proceed();
    }
}

