/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.web.rest;

import br.com.elotech.core.security.jwt.TokenGenerator;
import br.com.elotech.portalservicos.domain.PortalServicosAuthenticationDetails;
import br.com.elotech.portalservicos.web.rest.dto.PortalServicosLoginDTO;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PortalServicosAuthenticationController {
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private AuthenticationManager authenticationManager;

    @RequestMapping(value={"/api/authenticate"}, method={RequestMethod.POST})
    @Timed
    public ResponseEntity<PortalServicosAuthenticationDetails> authenticate(@Valid @RequestBody PortalServicosLoginDTO loginDTO, HttpServletResponse response) {
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)loginDTO.getUsername(), (Object)loginDTO.getPassword());
        Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        boolean rememberMe = BooleanUtils.isTrue((Boolean)loginDTO.isRememberMe());
        String jwt = this.tokenGenerator.createToken(authentication, Boolean.valueOf(rememberMe));
        String token = "Bearer " + jwt;
        PortalServicosAuthenticationDetails authenticationDetails = new PortalServicosAuthenticationDetails(jwt);
        response.addHeader("Authorization", token);
        return ResponseEntity.ok((Object)authenticationDetails);
    }
}

