/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.web.rest;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.portalservicos.domain.ParametroGeral;
import br.com.elotech.portalservicos.service.MailConfigParamsServiceImpl;
import br.com.elotech.portalservicos.service.ParametroGeralService;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametro-geral"})
public class ParametroGeralResource {
    private final MailConfigParamsServiceImpl mailConfigParamsServiceImpl;
    private final ParametroGeralService parametroGeralService;

    @Autowired
    public ParametroGeralResource(MailConfigParamsServiceImpl mailConfigParamsServiceImpl, ParametroGeralService parametroGeralService) {
        this.mailConfigParamsServiceImpl = mailConfigParamsServiceImpl;
        this.parametroGeralService = parametroGeralService;
    }

    @GetMapping(value={"/configuracoes-envio-email"})
    public ResponseEntity<List<ParametroGeral>> configuracoesEnvioEmail() {
        return ResponseEntity.ok().body((Object)this.mailConfigParamsServiceImpl.configuracoesEnvioEmail());
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{parametro}/modulo/{modulo}"})
    public ResponseEntity<ParametroGeral> update(@RequestBody @Valid ParametroGeral parametroGeral, @PathVariable(value="parametro") String parametro, @PathVariable(value="modulo") String modulo, @AuthenticationPrincipal Authentication authentication) {
        Preconditions.checkNotNull((Object)parametroGeral, (Object)"parametro geral n\u00e3o pode ser null");
        if (!this.parametroGeralService.exists(parametroGeral.getId()).booleanValue()) {
            throw RestException.notFound();
        }
        ParametroGeral saved = (ParametroGeral)this.parametroGeralService.save((EloEntity)parametroGeral, authentication);
        return ResponseEntity.ok((Object)saved);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{parametro}/modulo/{modulo}"})
    public ResponseEntity<ParametroGeral> findOne(@PathVariable(value="parametro") String parametro, @PathVariable(value="modulo") String modulo) {
        Preconditions.checkNotNull((Object)parametro, (Object)"par\u00e2metro n\u00e3o pode ser null");
        Preconditions.checkNotNull((Object)modulo, (Object)"m\u00f3dulo n\u00e3o pode ser null");
        ParametroGeral parametroGeral = this.parametroGeralService.findByModuloAndParametroToFront(modulo, parametro);
        if (parametroGeral == null) {
            throw RestException.notFound();
        }
        return ResponseEntity.ok((Object)parametroGeral);
    }
}

