/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.web.rest;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.portalservicos.domain.AcessoWeb;
import br.com.elotech.portalservicos.domain.support.UsuarioTrocaSenha;
import br.com.elotech.portalservicos.service.AcessoWebService;
import com.google.common.base.Strings;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/esqueci-minha-senha"})
public class EsqueciMinhaSenhaResource
extends CrudResource<AcessoWeb, Long> {
    private final AcessoWebService acessoWebService;

    @Autowired
    public EsqueciMinhaSenhaResource(AcessoWebService acessoWebService) {
        this.acessoWebService = acessoWebService;
    }

    @GetMapping(value={"/solicita-alteracao-senha"}, params={"cpf", "urlAtual"})
    public ResponseEntity<AcessoWeb> esqueciMinhaSenha(@RequestParam(value="cpf") String cpf, @RequestParam(value="urlAtual") String urlAtual, HttpServletRequest request) throws NoSuchAlgorithmException, InterruptedException, ExecutionException {
        if (Strings.isNullOrEmpty((String)urlAtual)) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel encontrar o endereco atual para formar a url de altera\u00e7\u00e3o de senha");
        }
        AcessoWeb acessoWeb = this.acessoWebService.esqueciMinhaSenha(cpf, urlAtual);
        return ResponseEntity.ok().body((Object)acessoWeb);
    }

    @PostMapping(value={"/alterar-senha"})
    public ResponseEntity<AcessoWeb> alterarSenha(@RequestBody UsuarioTrocaSenha usuarioTrocaSenha) throws NoSuchAlgorithmException {
        AcessoWeb acessoWeb = this.acessoWebService.alterarSenha(usuarioTrocaSenha);
        return ResponseEntity.ok().body((Object)acessoWeb);
    }
}

