/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.web.rest;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.portalservicos.domain.Entidade;
import br.com.elotech.portalservicos.service.EntidadeService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidades"})
public class EntidadeResource
extends ReadOnlyResource<Entidade, Long> {
    private EntidadeService getEntidadeService() {
        return (EntidadeService)this.getService();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/principal/brasao"}, produces={"image/jpeg"})
    public ResponseEntity<byte[]> getBrasaoPrincipal() {
        Optional entidadePrincipal = this.getEntidadeService().getEntidadePrincipal();
        if (entidadePrincipal.isPresent() && Objects.nonNull(((Entidade)entidadePrincipal.get()).getBrasao())) {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(((Entidade)entidadePrincipal.get()).getBrasao()));
            ByteArrayOutputStream outputJpg = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)outputJpg);
            return ResponseEntity.ok((Object)outputJpg.toByteArray());
        }
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/principal/entidade"})
    public ResponseEntity<Entidade> getEntidadePrincipal() {
        Optional entidadePrincipal = this.getEntidadeService().getEntidadePrincipal();
        if (entidadePrincipal.isPresent()) {
            return ResponseEntity.ok(entidadePrincipal.get());
        }
        return ResponseEntity.noContent().build();
    }
}

