/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.web.rest;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.portalservicos.domain.AcessoWeb;
import br.com.elotech.portalservicos.domain.support.UsuarioTrocaSenha;
import br.com.elotech.portalservicos.service.AcessoWebService;
import java.security.NoSuchAlgorithmException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/acesso-web"})
public class AcessoWebResource
extends CrudResource<AcessoWeb, Long> {
    private final AcessoWebService acessoWebService;

    @Autowired
    public AcessoWebResource(AcessoWebService acessoWebService) {
        this.acessoWebService = acessoWebService;
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<AcessoWeb> me(@AuthenticationPrincipal Authentication authentication) {
        AcessoWeb acessoWeb = this.acessoWebService.load(authentication.getName());
        return ResponseEntity.ok().body((Object)acessoWeb);
    }

    @GetMapping(value={"/validaCpf"}, params={"cpf"})
    public Boolean validaCpf(@RequestParam(value="cpf") String cpf) {
        return this.acessoWebService.validaCpf(cpf);
    }

    @PostMapping(value={"/change-password"})
    public ResponseEntity<Void> changePassword(@AuthenticationPrincipal Authentication authentication, @RequestBody UsuarioTrocaSenha usuarioTrocaSenha) throws NoSuchAlgorithmException {
        this.acessoWebService.trocaSenha(authentication, usuarioTrocaSenha);
        return ResponseEntity.ok().build();
    }

    public void beforeApplyPatch(AcessoWeb entity, Authentication authentication) {
        this.validaAcesso(entity, authentication);
    }

    private void validaAcesso(AcessoWeb entity, Authentication authentication) {
        if (!entity.getCpf().equals(authentication.getName())) {
            String message = String.format("Usu\u00e1rio autenticado diferente do que est\u00e1 sendo alterado.%nCPF Autencado: %s %nCPF sendo alterado: %s", authentication.getName(), entity.getCpf());
            throw new IllegalArgumentException(message);
        }
    }
}

