/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.portalservicos.domain.AcessoWebModulo;
import br.com.elotech.portalservicos.service.AcessoWebModuloService;
import br.com.elotech.portalservicos.web.rest.AcessoWebModuloResourceValidUtil;
import br.com.elotech.portalservicos.web.rest.dto.ModuloDTO;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/modulos"})
public class AcessoWebModuloResource
extends CrudResource<AcessoWebModulo, Long> {
    private final AcessoWebModuloService acessoWebModuloService;

    public AcessoWebModuloResource(AcessoWebModuloService acessoWebModuloService) {
        this.acessoWebModuloService = acessoWebModuloService;
    }

    @GetMapping(value={"/modulo-seletores"})
    public List<ModuloDTO> loadModulos() {
        return this.acessoWebModuloService.loadModulos();
    }

    public void beforeRemove(AcessoWebModulo acessoWeb) {
        if (acessoWeb.isModuloElotech().booleanValue()) {
            throw RestException.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE, (String)String.format("M\u00f3dulo %s S\u00f3 pode ser removido pelo suporte t\u00e9cnico!", acessoWeb.getDescricao()));
        }
    }

    public void beforePatch(AcessoWebModulo acessoWeb, List<JsonUpdatePartial> updates) {
        if (acessoWeb.isModuloElotech().booleanValue()) {
            AcessoWebModuloResourceValidUtil.validaPatch(updates);
        }
    }
}

