/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portalservicos.domain.ParametroGeral;
import br.com.elotech.portalservicos.repository.ParametroGeralRepository;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParametroGeralService
extends CrudService<ParametroGeral, Long> {
    private final ParametroGeralRepository parametroGeralRepository;

    @Autowired
    public ParametroGeralService(ParametroGeralRepository parametroGeralRepository) {
        this.parametroGeralRepository = parametroGeralRepository;
    }

    public List<String> somenteAtualizar() {
        return Arrays.asList("SENHASMTP");
    }

    public ParametroGeral findOneToFront(String modulo, String param) {
        ParametroGeral parametroEncontrado = this.findByModuloAndParametro(modulo, param);
        this.somenteAtualizar().forEach(parametro -> {
            if (parametroEncontrado.getParametro().equals(parametro)) {
                parametroEncontrado.setValor(null);
            }
        });
        return parametroEncontrado;
    }

    public ParametroGeral findByModuloAndParametro(String modulo, String parametro) {
        return this.parametroGeralRepository.findByModuloAndParametro(modulo, parametro);
    }

    public ParametroGeral findByModuloAndParametroToFront(String modulo, String param) {
        ParametroGeral parametroEncontrado = this.findByModuloAndParametro(modulo, param);
        this.somenteAtualizar().forEach(parametro -> {
            if (parametroEncontrado.getParametro().equals(parametro)) {
                parametroEncontrado.setValor(null);
            }
        });
        return parametroEncontrado;
    }

    public Boolean exists(Long id) {
        return this.parametroGeralRepository.existsById((Object)id);
    }
}

