/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.mail.MailConfigParamsService;
import br.com.elotech.portalservicos.domain.ParametroGeral;
import br.com.elotech.portalservicos.service.MailParametroGeralEnum;
import br.com.elotech.portalservicos.service.ParametroGeralService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MailConfigParamsServiceImpl
implements MailConfigParamsService {
    private final ParametroGeralService parametroGeralService;

    @Autowired
    public MailConfigParamsServiceImpl(ParametroGeralService parametroGeralService) {
        this.parametroGeralService = parametroGeralService;
    }

    public String getHost() {
        return this.getParametroHost().getValor();
    }

    public ParametroGeral getParametroHost() {
        return this.parametroGeralService.findByModuloAndParametro(ModuloEnum.MODULO_MAIS_ISS.getValue(), MailParametroGeralEnum.SERVIDORSMTP.name());
    }

    public int getPort() {
        String porta = this.getParametroPort().getValor();
        if (Objects.nonNull(porta)) {
            return Integer.valueOf(porta);
        }
        return 0;
    }

    public ParametroGeral getParametroPort() {
        return this.parametroGeralService.findByModuloAndParametro(ModuloEnum.MODULO_MAIS_ISS.getValue(), MailParametroGeralEnum.PORTASMTP.name());
    }

    public String getUserName() {
        return this.getParametroUserName().getValor();
    }

    public ParametroGeral getParametroUserName() {
        return this.parametroGeralService.findByModuloAndParametro(ModuloEnum.MODULO_MAIS_ISS.getValue(), MailParametroGeralEnum.USUARIOSMTP.name());
    }

    public String getPassword() {
        return this.getParametroPassword().getValor();
    }

    public ParametroGeral getParametroPassword() {
        return this.parametroGeralService.findByModuloAndParametro(ModuloEnum.MODULO_MAIS_ISS.getValue(), MailParametroGeralEnum.SENHASMTP.name());
    }

    public ParametroGeral getParametroPasswordToFront() {
        return this.parametroGeralService.findByModuloAndParametro(ModuloEnum.MODULO_MAIS_ISS.getValue(), MailParametroGeralEnum.SENHASMTP.name());
    }

    public List<ParametroGeral> configuracoesEnvioEmail() {
        return Arrays.asList(this.getParametroHost(), this.getParametroPort(), this.getParametroUserName(), this.getParametroPasswordToFront());
    }
}

