/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.service;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.portalservicos.domain.AcessoWeb;
import java.util.Locale;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service
public class EsqueciMinhaSenhaMailServiceImpl {
    private final Logger log = LoggerFactory.getLogger(EsqueciMinhaSenhaMailServiceImpl.class);
    private final Locale locale = Locale.getDefault();
    private final SpringTemplateEngine templateEngine;
    private final MailService mailService;

    public EsqueciMinhaSenhaMailServiceImpl(SpringTemplateEngine templateEngine, MailService mailService) {
        this.templateEngine = templateEngine;
        this.mailService = mailService;
    }

    public Future<Boolean> enviaEmail(AcessoWeb acessoWeb, String urlAtual) {
        this.log.debug("Enviando email de altera\u00e7\u00e3o de senha para '{}'", (Object)acessoWeb.getContato().getEmail());
        String content = this.buildContent(acessoWeb, urlAtual);
        MailParams params = this.buildParams(acessoWeb, content);
        return this.mailService.sendEmail(params);
    }

    protected MailParams buildParams(AcessoWeb acessoWeb, String content) {
        return MailParams.builder().to(acessoWeb.getContato().getEmail()).subject("Solicita\u00e7\u00e3o de alera\u00e7\u00e3o de senha").content(content).multipart(false).html(true).build();
    }

    protected String buildContent(AcessoWeb acessoWeb, String urlAtual) {
        Context context = this.buildThymeleafContext(acessoWeb, urlAtual);
        return this.templateEngine.process("trocar-senha", (IContext)context);
    }

    protected Context buildThymeleafContext(AcessoWeb acessoWeb, String urlAtual) {
        Context context = new Context(this.locale);
        context.setVariable("url", (Object)this.buildUrl(acessoWeb, urlAtual));
        context.setVariable("validade", (Object)acessoWeb.formatDataLimiteAcessoEsqueciMinhaSenha());
        return context;
    }

    protected String buildUrl(AcessoWeb acessoWeb, String urlAtual) {
        StringBuilder sb = new StringBuilder();
        sb.append(urlAtual);
        sb.append("/efetua-alteracao-senha?codigoAcessoEsqueciMinhaSenha=");
        sb.append(acessoWeb.getCodigoAcessoEsqueciMinhaSenha());
        return sb.toString();
    }
}

